/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;

public class NpmPackageIndexBuilder {
    public static final Integer CURRENT_INDEX_VERSION = 2;
    private JsonObject index;
    private JsonArray files;
    private Connection conn;
    private PreparedStatement psql;
    private String dbFilename;

    public void start(String filename) {
        this.index = new JsonObject();
        this.index.add("index-version", CURRENT_INDEX_VERSION);
        this.files = new JsonArray();
        this.index.add("files", this.files);
        this.dbFilename = filename;
        if (filename != null) {
            try {
                new File(filename).delete();
                this.conn = DriverManager.getConnection("jdbc:sqlite:" + filename);
                Statement stmt = this.conn.createStatement();
                stmt.execute("CREATE TABLE ResourceList (\r\nFileName       nvarchar NOT NULL,\r\nResourceType   nvarchar NOT NULL,\r\nId             nvarchar NULL,\r\nUrl            nvarchar NULL,\r\nVersion        nvarchar NULL,\r\nKind           nvarchar NULL,\r\nType           nvarchar NULL,\r\nSupplements    nvarchar NULL,\r\nContent        nvarchar NULL,\r\nValueSet       nvarchar NULL,\r\nDerivation     nvarchar NULL,\r\nPRIMARY KEY (FileName))\r\n");
                this.psql = this.conn.prepareStatement("Insert into ResourceList (FileName, ResourceType, Id, Url, Version, Kind, Type, Supplements, Content, ValueSet) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            }
            catch (Exception e) {
                if (this.conn != null) {
                    try {
                        this.conn.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.conn = null;
            }
        }
    }

    public boolean seeFile(String name, byte[] content) {
        block14: {
            if (name.endsWith(".json")) {
                try {
                    JsonObject json = JsonParser.parseObject(content);
                    if (json.has("resourceType")) {
                        JsonObject fi = new JsonObject();
                        this.files.add(fi);
                        fi.add("filename", name);
                        fi.add("resourceType", json.asString("resourceType"));
                        if (json.hasPrimitive("id")) {
                            fi.add("id", json.asString("id"));
                        }
                        if (json.hasPrimitive("url")) {
                            fi.add("url", json.asString("url"));
                        }
                        if (json.hasPrimitive("version")) {
                            fi.add("version", json.asString("version"));
                        }
                        if (json.hasPrimitive("kind")) {
                            fi.add("kind", json.asString("kind"));
                        }
                        if (json.hasPrimitive("type")) {
                            fi.add("type", json.asString("type"));
                        }
                        if (json.hasPrimitive("supplements")) {
                            fi.add("supplements", json.asString("supplements"));
                        }
                        if (json.hasPrimitive("content")) {
                            fi.add("content", json.asString("content"));
                        }
                        if (json.hasPrimitive("valueSet")) {
                            fi.add("valueSet", json.asString("valueSet"));
                        }
                        if (json.hasPrimitive("derivation")) {
                            fi.add("derivation", json.asString("derivation"));
                        }
                        if (this.psql != null) {
                            this.psql.setString(1, name);
                            this.psql.setString(2, json.asString("resourceType"));
                            this.psql.setString(3, json.asString("id"));
                            this.psql.setString(4, json.asString("url"));
                            this.psql.setString(5, json.asString("version"));
                            this.psql.setString(6, json.asString("kind"));
                            this.psql.setString(7, json.asString("type"));
                            this.psql.setString(8, json.asString("supplements"));
                            this.psql.setString(9, json.asString("content"));
                            this.psql.setString(10, json.asString("valueSet"));
                            this.psql.setString(10, json.asString("derivation"));
                            this.psql.execute();
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println("Error parsing " + name + ": " + e.getMessage());
                    if (!name.contains("openapi")) break block14;
                    return false;
                }
            }
        }
        return true;
    }

    public String build() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String res = JsonParser.compose((JsonElement)this.index, true);
        this.index = null;
        this.files = null;
        return res;
    }

    public void executeWithStatus(String folder) throws IOException {
        System.out.print("Index Package " + folder + " ... ");
        this.execute(folder);
        System.out.println("done");
    }

    public void execute(String folder) throws IOException {
        if (this.existsFolder(folder, "package")) {
            folder = Utilities.path(folder, "package");
        }
        if (!this.existsFile(folder, "package.json")) {
            throw new FHIRException("Not a proper package? (can't find package.json)");
        }
        this.start(Utilities.path(folder, ".index.db"));
        File dir = new File(folder);
        for (File f : dir.listFiles()) {
            this.seeFile(f.getName(), TextFile.fileToBytes(f));
        }
        TextFile.stringToFile(this.build(), Utilities.path(folder, ".index.json"));
    }

    private boolean existsFolder(String ... args) throws IOException {
        File f = new File(Utilities.path(args));
        return f.exists() && f.isDirectory();
    }

    private boolean existsFile(String ... args) throws IOException {
        File f = new File(Utilities.path(args));
        return f.exists() && !f.isDirectory();
    }

    public static void main(String[] args) throws IOException {
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r4.core");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r4.examples");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r4.expansions");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r4.elements");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r3.core");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r3.examples");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r3.expansions");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r3.elements");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2b.core");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2b.examples");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2b.expansions");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2.core");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2.examples");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2.expansions");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.r2.elements");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.test.data\\fhir.test.data.r2");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.test.data\\fhir.test.data.r3");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.test.data\\fhir.test.data.r4");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.tx.support\\fhir.tx.support.r2");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.tx.support\\fhir.tx.support.r3");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\fhir.tx.support\\fhir.tx.support.r4");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.core#1.0.2");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.core#1.4.0");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.core#3.0.2");
        new NpmPackageIndexBuilder().executeWithStatus("C:\\work\\org.hl7.fhir\\packages\\hl7.fhir.rX\\hl7.fhir.core#4.0.1");
    }

    public String getDbFilename() {
        return this.dbFilename;
    }
}

