/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.hl7.fhir.utilities.TextStreamWriter;

public class CSVWriter
extends TextStreamWriter {
    public CSVWriter(OutputStream out) throws UnsupportedEncodingException {
        super(out);
    }

    protected String csvEscape(String s) {
        if (s == null) {
            return "";
        }
        if (s.contains("\"")) {
            return s.substring(0, s.indexOf("\"")) + "\"" + this.csvEscape(s.substring(s.indexOf("\"") + 1));
        }
        if (s.contains(",")) {
            return "\"" + s + "\"";
        }
        return s;
    }

    public void line(String ... fields) throws IOException {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (String s : fields) {
            if (first) {
                first = false;
            } else {
                b.append(",");
            }
            b.append(this.csvEscape(s));
        }
        this.ln(b.toString());
    }
}

