/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NamedItemList<T extends NamedItem>
implements Collection<T> {
    private static final int SIZE_CUTOFF_MAP = 10;
    private List<T> list = new ArrayList<T>();
    private Map<String, List<T>> map = null;

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(T e) {
        this.map = null;
        return this.list.add(e);
    }

    public void add(int index, T e) {
        this.list.add(index, e);
        this.map = null;
    }

    @Override
    public boolean remove(Object o) {
        this.map = null;
        return this.list.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.list.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.map = null;
        return this.list.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.map = null;
        return this.list.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.map = null;
        return this.list.retainAll(c);
    }

    @Override
    public void clear() {
        this.list.clear();
        this.map = null;
    }

    public List<T> getByName(String name) {
        ArrayList<Object> res = new ArrayList<Object>();
        if (this.size() > 10) {
            List<T> l;
            if (this.map == null) {
                this.buildMap();
            }
            if ((l = this.map.get(name)) != null) {
                res.addAll(l);
            }
        } else {
            for (NamedItem child : this.list) {
                if (!name.equals(child.getListName())) continue;
                res.add(child);
            }
        }
        return res;
    }

    public T get(int c) {
        return (T)((NamedItem)this.list.get(c));
    }

    private void buildMap() {
        this.map = new HashMap<String, List<T>>();
        for (NamedItem child : this.list) {
            String n = child.getListName();
            List<T> l = this.map.get(n);
            if (l == null) {
                l = new ArrayList<T>();
                this.map.put(n, l);
            }
            l.add(child);
        }
    }

    public void sort(Comparator<? super T> sorter) {
        Collections.sort(this.list, sorter);
    }

    public void clearMap() {
        this.map = null;
    }

    public static interface NamedItem {
        public String getListName();
    }
}

