/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xml;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class XMLUtil {
    public static final String SPACE_CHAR = "\u00a0";

    public static boolean isNMToken(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            if (XMLUtil.isNMTokenChar(name.charAt(i))) continue;
            return false;
        }
        return name.length() > 0;
    }

    public static boolean isNMTokenChar(char c) {
        return XMLUtil.isLetter(c) || XMLUtil.isDigit(c) || c == '.' || c == '-' || c == '_' || c == ':' || XMLUtil.isCombiningChar(c) || XMLUtil.isExtender(c);
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9' || c >= '\u0660' && c <= '\u0669' || c >= '\u06f0' && c <= '\u06f9' || c >= '\u0966' && c <= '\u096f' || c >= '\u09e6' && c <= '\u09ef' || c >= '\u0a66' && c <= '\u0a6f' || c >= '\u0ae6' && c <= '\u0aef' || c >= '\u0b66' && c <= '\u0b6f' || c >= '\u0be7' && c <= '\u0bef' || c >= '\u0c66' && c <= '\u0c6f' || c >= '\u0ce6' && c <= '\u0cef' || c >= '\u0d66' && c <= '\u0d6f' || c >= '\u0e50' && c <= '\u0e59' || c >= '\u0ed0' && c <= '\u0ed9' || c >= '\u0f20' && c <= '\u0f29';
    }

    private static boolean isCombiningChar(char c) {
        return c >= '\u0300' && c <= '\u0345' || c >= '\u0360' && c <= '\u0361' || c >= '\u0483' && c <= '\u0486' || c >= '\u0591' && c <= '\u05a1' || c >= '\u05a3' && c <= '\u05b9' || c >= '\u05bb' && c <= '\u05bd' || c == '\u05bf' || c >= '\u05c1' && c <= '\u05c2' || c == '\u05c4' || c >= '\u064b' && c <= '\u0652' || c == '\u0670' || c >= '\u06d6' && c <= '\u06dc' || c >= '\u06dd' && c <= '\u06df' || c >= '\u06e0' && c <= '\u06e4' || c >= '\u06e7' && c <= '\u06e8' || c >= '\u06ea' && c <= '\u06ed' || c >= '\u0901' && c <= '\u0903' || c == '\u093c' || c >= '\u093e' && c <= '\u094c' || c == '\u094d' || c >= '\u0951' && c <= '\u0954' || c >= '\u0962' && c <= '\u0963' || c >= '\u0981' && c <= '\u0983' || c == '\u09bc' || c == '\u09be' || c == '\u09bf' || c >= '\u09c0' && c <= '\u09c4' || c >= '\u09c7' && c <= '\u09c8' || c >= '\u09cb' && c <= '\u09cd' || c == '\u09d7' || c >= '\u09e2' && c <= '\u09e3' || c == '\u0a02' || c == '\u0a3c' || c == '\u0a3e' || c == '\u0a3f' || c >= '\u0a40' && c <= '\u0a42' || c >= '\u0a47' && c <= '\u0a48' || c >= '\u0a4b' && c <= '\u0a4d' || c >= '\u0a70' && c <= '\u0a71' || c >= '\u0a81' && c <= '\u0a83' || c == '\u0abc' || c >= '\u0abe' && c <= '\u0ac5' || c >= '\u0ac7' && c <= '\u0ac9' || c >= '\u0acb' && c <= '\u0acd' || c >= '\u0b01' && c <= '\u0b03' || c == '\u0b3c' || c >= '\u0b3e' && c <= '\u0b43' || c >= '\u0b47' && c <= '\u0b48' || c >= '\u0b4b' && c <= '\u0b4d' || c >= '\u0b56' && c <= '\u0b57' || c >= '\u0b82' && c <= '\u0b83' || c >= '\u0bbe' && c <= '\u0bc2' || c >= '\u0bc6' && c <= '\u0bc8' || c >= '\u0bca' && c <= '\u0bcd' || c == '\u0bd7' || c >= '\u0c01' && c <= '\u0c03' || c >= '\u0c3e' && c <= '\u0c44' || c >= '\u0c46' && c <= '\u0c48' || c >= '\u0c4a' && c <= '\u0c4d' || c >= '\u0c55' && c <= '\u0c56' || c >= '\u0c82' && c <= '\u0c83' || c >= '\u0cbe' && c <= '\u0cc4' || c >= '\u0cc6' && c <= '\u0cc8' || c >= '\u0cca' && c <= '\u0ccd' || c >= '\u0cd5' && c <= '\u0cd6' || c >= '\u0d02' && c <= '\u0d03' || c >= '\u0d3e' && c <= '\u0d43' || c >= '\u0d46' && c <= '\u0d48' || c >= '\u0d4a' && c <= '\u0d4d' || c == '\u0d57' || c == '\u0e31' || c >= '\u0e34' && c <= '\u0e3a' || c >= '\u0e47' && c <= '\u0e4e' || c == '\u0eb1' || c >= '\u0eb4' && c <= '\u0eb9' || c >= '\u0ebb' && c <= '\u0ebc' || c >= '\u0ec8' && c <= '\u0ecd' || c >= '\u0f18' && c <= '\u0f19' || c == '\u0f35' || c == '\u0f37' || c == '\u0f39' || c == '\u0f3e' || c == '\u0f3f' || c >= '\u0f71' && c <= '\u0f84' || c >= '\u0f86' && c <= '\u0f8b' || c >= '\u0f90' && c <= '\u0f95' || c == '\u0f97' || c >= '\u0f99' && c <= '\u0fad' || c >= '\u0fb1' && c <= '\u0fb7' || c == '\u0fb9' || c >= '\u20d0' && c <= '\u20dc' || c == '\u20e1' || c >= '\u302a' && c <= '\u302f' || c == '\u3099' || c == '\u309a';
    }

    private static boolean isExtender(char c) {
        return c == '\u00b7' || c == '\u02d0' || c == '\u02d1' || c == '\u0387' || c == '\u0640' || c == '\u0e46' || c == '\u0ec6' || c == '\u3005' || c >= '\u3031' && c <= '\u3035' || c >= '\u309d' && c <= '\u309e' || c >= '\u30fc' && c <= '\u30fe';
    }

    private static boolean isLetter(char c) {
        return XMLUtil.isBaseChar(c) || XMLUtil.isIdeographic(c);
    }

    private static boolean isBaseChar(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '\u00c0' && c <= '\u00d6' || c >= '\u00d8' && c <= '\u00f6' || c >= '\u00f8' && c <= '\u00ff' || c >= '\u0100' && c <= '\u0131' || c >= '\u0134' && c <= '\u013e' || c >= '\u0141' && c <= '\u0148' || c >= '\u014a' && c <= '\u017e' || c >= '\u0180' && c <= '\u01c3' || c >= '\u01cd' && c <= '\u01f0' || c >= '\u01f4' && c <= '\u01f5' || c >= '\u01fa' && c <= '\u0217' || c >= '\u0250' && c <= '\u02a8' || c >= '\u02bb' && c <= '\u02c1' || c == '\u0386' || c >= '\u0388' && c <= '\u038a' || c == '\u038c' || c >= '\u038e' && c <= '\u03a1' || c >= '\u03a3' && c <= '\u03ce' || c >= '\u03d0' && c <= '\u03d6' || c == '\u03da' || c == '\u03dc' || c == '\u03de' || c == '\u03e0' || c >= '\u03e2' && c <= '\u03f3' || c >= '\u0401' && c <= '\u040c' || c >= '\u040e' && c <= '\u044f' || c >= '\u0451' && c <= '\u045c' || c >= '\u045e' && c <= '\u0481' || c >= '\u0490' && c <= '\u04c4' || c >= '\u04c7' && c <= '\u04c8' || c >= '\u04cb' && c <= '\u04cc' || c >= '\u04d0' && c <= '\u04eb' || c >= '\u04ee' && c <= '\u04f5' || c >= '\u04f8' && c <= '\u04f9' || c >= '\u0531' && c <= '\u0556' || c == '\u0559' || c >= '\u0561' && c <= '\u0586' || c >= '\u05d0' && c <= '\u05ea' || c >= '\u05f0' && c <= '\u05f2' || c >= '\u0621' && c <= '\u063a' || c >= '\u0641' && c <= '\u064a' || c >= '\u0671' && c <= '\u06b7' || c >= '\u06ba' && c <= '\u06be' || c >= '\u06c0' && c <= '\u06ce' || c >= '\u06d0' && c <= '\u06d3' || c == '\u06d5' || c >= '\u06e5' && c <= '\u06e6' || c >= '\u0905' && c <= '\u0939' || c == '\u093d' || c >= '\u0958' && c <= '\u0961' || c >= '\u0985' && c <= '\u098c' || c >= '\u098f' && c <= '\u0990' || c >= '\u0993' && c <= '\u09a8' || c >= '\u09aa' && c <= '\u09b0' || c == '\u09b2' || c >= '\u09b6' && c <= '\u09b9' || c >= '\u09dc' && c <= '\u09dd' || c >= '\u09df' && c <= '\u09e1' || c >= '\u09f0' && c <= '\u09f1' || c >= '\u0a05' && c <= '\u0a0a' || c >= '\u0a0f' && c <= '\u0a10' || c >= '\u0a13' && c <= '\u0a28' || c >= '\u0a2a' && c <= '\u0a30' || c >= '\u0a32' && c <= '\u0a33' || c >= '\u0a35' && c <= '\u0a36' || c >= '\u0a38' && c <= '\u0a39' || c >= '\u0a59' && c <= '\u0a5c' || c == '\u0a5e' || c >= '\u0a72' && c <= '\u0a74' || c >= '\u0a85' && c <= '\u0a8b' || c == '\u0a8d' || c >= '\u0a8f' && c <= '\u0a91' || c >= '\u0a93' && c <= '\u0aa8' || c >= '\u0aaa' && c <= '\u0ab0' || c >= '\u0ab2' && c <= '\u0ab3' || c >= '\u0ab5' && c <= '\u0ab9' || c == '\u0abd' || c == '\u0ae0' || c >= '\u0b05' && c <= '\u0b0c' || c >= '\u0b0f' && c <= '\u0b10' || c >= '\u0b13' && c <= '\u0b28' || c >= '\u0b2a' && c <= '\u0b30' || c >= '\u0b32' && c <= '\u0b33' || c >= '\u0b36' && c <= '\u0b39' || c == '\u0b3d' || c >= '\u0b5c' && c <= '\u0b5d' || c >= '\u0b5f' && c <= '\u0b61' || c >= '\u0b85' && c <= '\u0b8a' || c >= '\u0b8e' && c <= '\u0b90' || c >= '\u0b92' && c <= '\u0b95' || c >= '\u0b99' && c <= '\u0b9a' || c == '\u0b9c' || c >= '\u0b9e' && c <= '\u0b9f' || c >= '\u0ba3' && c <= '\u0ba4' || c >= '\u0ba8' && c <= '\u0baa' || c >= '\u0bae' && c <= '\u0bb5' || c >= '\u0bb7' && c <= '\u0bb9' || c >= '\u0c05' && c <= '\u0c0c' || c >= '\u0c0e' && c <= '\u0c10' || c >= '\u0c12' && c <= '\u0c28' || c >= '\u0c2a' && c <= '\u0c33' || c >= '\u0c35' && c <= '\u0c39' || c >= '\u0c60' && c <= '\u0c61' || c >= '\u0c85' && c <= '\u0c8c' || c >= '\u0c8e' && c <= '\u0c90' || c >= '\u0c92' && c <= '\u0ca8' || c >= '\u0caa' && c <= '\u0cb3' || c >= '\u0cb5' && c <= '\u0cb9' || c == '\u0cde' || c >= '\u0ce0' && c <= '\u0ce1' || c >= '\u0d05' && c <= '\u0d0c' || c >= '\u0d0e' && c <= '\u0d10' || c >= '\u0d12' && c <= '\u0d28' || c >= '\u0d2a' && c <= '\u0d39' || c >= '\u0d60' && c <= '\u0d61' || c >= '\u0e01' && c <= '\u0e2e' || c == '\u0e30' || c >= '\u0e32' && c <= '\u0e33' || c >= '\u0e40' && c <= '\u0e45' || c >= '\u0e81' && c <= '\u0e82' || c == '\u0e84' || c >= '\u0e87' && c <= '\u0e88' || c == '\u0e8a' || c == '\u0e8d' || c >= '\u0e94' && c <= '\u0e97' || c >= '\u0e99' && c <= '\u0e9f' || c >= '\u0ea1' && c <= '\u0ea3' || c == '\u0ea5' || c == '\u0ea7' || c >= '\u0eaa' && c <= '\u0eab' || c >= '\u0ead' && c <= '\u0eae' || c == '\u0eb0' || c >= '\u0eb2' && c <= '\u0eb3' || c == '\u0ebd' || c >= '\u0ec0' && c <= '\u0ec4' || c >= '\u0f40' && c <= '\u0f47' || c >= '\u0f49' && c <= '\u0f69' || c >= '\u10a0' && c <= '\u10c5' || c >= '\u10d0' && c <= '\u10f6' || c == '\u1100' || c >= '\u1102' && c <= '\u1103' || c >= '\u1105' && c <= '\u1107' || c == '\u1109' || c >= '\u110b' && c <= '\u110c' || c >= '\u110e' && c <= '\u1112' || c == '\u113c' || c == '\u113e' || c == '\u1140' || c == '\u114c' || c == '\u114e' || c == '\u1150' || c >= '\u1154' && c <= '\u1155' || c == '\u1159' || c >= '\u115f' && c <= '\u1161' || c == '\u1163' || c == '\u1165' || c == '\u1167' || c == '\u1169' || c >= '\u116d' && c <= '\u116e' || c >= '\u1172' && c <= '\u1173' || c == '\u1175' || c == '\u119e' || c == '\u11a8' || c == '\u11ab' || c >= '\u11ae' && c <= '\u11af' || c >= '\u11b7' && c <= '\u11b8' || c == '\u11ba' || c >= '\u11bc' && c <= '\u11c2' || c == '\u11eb' || c == '\u11f0' || c == '\u11f9' || c >= '\u1e00' && c <= '\u1e9b' || c >= '\u1ea0' && c <= '\u1ef9' || c >= '\u1f00' && c <= '\u1f15' || c >= '\u1f18' && c <= '\u1f1d' || c >= '\u1f20' && c <= '\u1f45' || c >= '\u1f48' && c <= '\u1f4d' || c >= '\u1f50' && c <= '\u1f57' || c == '\u1f59' || c == '\u1f5b' || c == '\u1f5d' || c >= '\u1f5f' && c <= '\u1f7d' || c >= '\u1f80' && c <= '\u1fb4' || c >= '\u1fb6' && c <= '\u1fbc' || c == '\u1fbe' || c >= '\u1fc2' && c <= '\u1fc4' || c >= '\u1fc6' && c <= '\u1fcc' || c >= '\u1fd0' && c <= '\u1fd3' || c >= '\u1fd6' && c <= '\u1fdb' || c >= '\u1fe0' && c <= '\u1fec' || c >= '\u1ff2' && c <= '\u1ff4' || c >= '\u1ff6' && c <= '\u1ffc' || c == '\u2126' || c >= '\u212a' && c <= '\u212b' || c == '\u212e' || c >= '\u2180' && c <= '\u2182' || c >= '\u3041' && c <= '\u3094' || c >= '\u30a1' && c <= '\u30fa' || c >= '\u3105' && c <= '\u312c' || c >= '\uac00' && c <= '\ud7a3';
    }

    private static boolean isIdeographic(char c) {
        return c >= '\u4e00' && c <= '\u9fa5' || c == '\u3007' || c >= '\u3021' && c <= '\u3029';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String determineEncoding(InputStream stream) throws IOException {
        stream.mark(20000);
        try {
            int b0 = stream.read();
            int b1 = stream.read();
            int b2 = stream.read();
            int b3 = stream.read();
            if (b0 == 254 && b1 == 255) {
                String string = "UTF-16BE";
                return string;
            }
            if (b0 == 255 && b1 == 254) {
                String string = "UTF-16LE";
                return string;
            }
            if (b0 == 239 && b1 == 187 && b2 == 191) {
                String string = "UTF-8";
                return string;
            }
            if (b0 == 0 && b1 == 60 && b2 == 0 && b3 == 63) {
                String string = "UTF-16BE";
                return string;
            }
            if (b0 == 60 && b1 == 0 && b2 == 63 && b3 == 0) {
                String string = "UTF-16LE";
                return string;
            }
            if (b0 == 60 && b1 == 63 && b2 == 120 && b3 == 109) {
                InputStreamReader rdr = new InputStreamReader(stream, "US-ASCII");
                String hdr = XMLUtil.readFirstLine(rdr);
                String string = XMLUtil.extractEncoding(hdr);
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            stream.reset();
        }
    }

    private static String extractEncoding(String hdr) {
        int i = hdr.indexOf("encoding=");
        if (i == -1) {
            return null;
        }
        hdr = hdr.substring(i + 9);
        char sep = hdr.charAt(0);
        i = (hdr = hdr.substring(1)).indexOf(sep);
        if (i == -1) {
            return null;
        }
        return hdr.substring(0, i);
    }

    private static String readFirstLine(InputStreamReader rdr) throws IOException {
        char[] buf = new char[1];
        StringBuffer bldr = new StringBuffer();
        rdr.read(buf);
        while (buf[0] != '>') {
            bldr.append(buf[0]);
            rdr.read(buf);
        }
        return bldr.toString();
    }

    public static boolean charSetImpliesAscii(String charset) {
        return charset.equals("ISO-8859-1") || charset.equals("US-ASCII");
    }

    public static String escapeXML(String rawContent, String charset, boolean isNoLines) {
        if (rawContent == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < rawContent.length(); ++i) {
            char ch = rawContent.charAt(i);
            if (ch == '&') {
                sb.append("&amp;");
                continue;
            }
            if (ch == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (ch == '<') {
                sb.append("&lt;");
                continue;
            }
            if (ch == '>') {
                sb.append("&gt;");
                continue;
            }
            if (ch > '~' && charset != null && XMLUtil.charSetImpliesAscii(charset)) {
                sb.append("&#x" + Integer.toHexString(ch).toUpperCase() + ";");
                continue;
            }
            if (isNoLines) {
                if (ch == '\r') {
                    sb.append("&#xA;");
                    continue;
                }
                if (ch == '\n') continue;
                sb.append(ch);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static Element getFirstChild(Element e) {
        Node n;
        if (e == null) {
            return null;
        }
        for (n = e.getFirstChild(); n != null && n.getNodeType() != 1; n = n.getNextSibling()) {
        }
        return (Element)n;
    }

    public static Element getNamedChild(Element e, String name) {
        Element c = XMLUtil.getFirstChild(e);
        while (c != null && !name.equals(c.getLocalName()) && !name.equals(c.getNodeName())) {
            c = XMLUtil.getNextSibling(c);
        }
        return c;
    }

    public static Element getNamedChildByAttribute(Element e, String name, String nname, String nvalue) {
        Element c = XMLUtil.getFirstChild(e);
        while (!(c == null || (name.equals(c.getLocalName()) || name.equals(c.getNodeName())) && nvalue.equals(c.getAttribute(nname)))) {
            c = XMLUtil.getNextSibling(c);
        }
        return c;
    }

    public static Element getNextSibling(Element e) {
        Node n;
        for (n = e.getNextSibling(); n != null && n.getNodeType() != 1; n = n.getNextSibling()) {
        }
        return (Element)n;
    }

    public static void getNamedChildren(Element e, String name, List<Element> set) {
        Element c = XMLUtil.getFirstChild(e);
        while (c != null) {
            if (name.equals(c.getLocalName()) || name.equals(c.getNodeName())) {
                set.add(c);
            }
            c = XMLUtil.getNextSibling(c);
        }
    }

    public static List<Element> getNamedChildren(Element e, String name) {
        ArrayList<Element> res = new ArrayList<Element>();
        Element c = XMLUtil.getFirstChild(e);
        while (c != null) {
            if (name.equals(c.getLocalName()) || name.equals(c.getNodeName())) {
                res.add(c);
            }
            c = XMLUtil.getNextSibling(c);
        }
        return res;
    }

    public static String htmlToXmlEscapedPlainText(Element r) {
        StringBuilder s = new StringBuilder();
        boolean ws = false;
        for (Node n = r.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() == 3) {
                String t = n.getTextContent().trim();
                if (Utilities.noString(t)) {
                    ws = true;
                } else {
                    if (ws) {
                        s.append(" ");
                    }
                    ws = false;
                    s.append(t);
                }
            }
            if (n.getNodeType() != 1) continue;
            if (ws) {
                s.append(" ");
            }
            ws = false;
            s.append(XMLUtil.htmlToXmlEscapedPlainText((Element)n));
            if (!r.getNodeName().equals("br") && !r.getNodeName().equals("p")) continue;
            s.append("\r\n");
        }
        return s.toString();
    }

    public static String htmlToXmlEscapedPlainText(String definition) throws ParserConfigurationException, SAXException, IOException {
        return XMLUtil.htmlToXmlEscapedPlainText(XMLUtil.parseToDom("<div>" + definition + "</div>").getDocumentElement());
    }

    public static String elementToString(Element el) {
        if (el == null) {
            return "";
        }
        Document document = el.getOwnerDocument();
        DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)document.getImplementation());
        LSSerializer serializer = domImplLS.createLSSerializer();
        return serializer.writeToString(el);
    }

    public static String getNamedChildValue(Element element, String name) {
        Element e = XMLUtil.getNamedChild(element, name);
        return e == null ? null : e.getAttribute("value");
    }

    public static void setNamedChildValue(Element element, String name, String value) throws FHIRException {
        Element e = XMLUtil.getNamedChild(element, name);
        if (e == null) {
            throw new FHIRException("unable to find element " + name);
        }
        e.setAttribute("value", value);
    }

    public static void getNamedChildrenWithWildcard(Element focus, String name, List<Element> children) {
        Element c = XMLUtil.getFirstChild(focus);
        while (c != null) {
            String n;
            String string = n = c.getLocalName() != null ? c.getLocalName() : c.getNodeName();
            if (name.equals(n) || name.endsWith("[x]") && n.startsWith(name.substring(0, name.length() - 3))) {
                children.add(c);
            }
            c = XMLUtil.getNextSibling(c);
        }
    }

    public static void getNamedChildrenWithTails(Element focus, String name, List<Element> children, Set<String> typeTails) {
        Element c = XMLUtil.getFirstChild(focus);
        while (c != null) {
            String n;
            String string = n = c.getLocalName() != null ? c.getLocalName() : c.getNodeName();
            if (n.equals(name) || !n.equals("responseCode") && n.startsWith(name) && typeTails.contains(n.substring(name.length()))) {
                children.add(c);
            }
            c = XMLUtil.getNextSibling(c);
        }
    }

    public static boolean hasNamedChild(Element e, String name) {
        Element c = XMLUtil.getFirstChild(e);
        while (c != null && !name.equals(c.getLocalName()) && !name.equals(c.getNodeName())) {
            c = XMLUtil.getNextSibling(c);
        }
        return c != null;
    }

    public static Document parseToDom(String content) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new ByteArrayInputStream(content.getBytes()));
    }

    public static Document parseToDom(byte[] content) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new ByteArrayInputStream(content));
    }

    public static Document parseToDom(byte[] content, boolean ns) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(ns);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new ByteArrayInputStream(content));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseFileToDom(String filename) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        try (FileInputStream fs = ManagedFileAccess.inStream(filename);){
            Document document = builder.parse(fs);
            return document;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document parseFileToDom(String filename, boolean ns) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(ns);
        DocumentBuilder builder = factory.newDocumentBuilder();
        try (FileInputStream fs = ManagedFileAccess.inStream(filename);){
            Document document = builder.parse(fs);
            return document;
        }
    }

    public static Element getLastChild(Element e) {
        Node n;
        if (e == null) {
            return null;
        }
        for (n = e.getLastChild(); n != null && n.getNodeType() != 1; n = n.getPreviousSibling()) {
        }
        return (Element)n;
    }

    public static Element getPrevSibling(Element e) {
        Node n;
        for (n = e.getPreviousSibling(); n != null && n.getNodeType() != 1; n = n.getPreviousSibling()) {
        }
        return (Element)n;
    }

    public static String getNamedChildAttribute(Element element, String name, String aname) {
        Element e = XMLUtil.getNamedChild(element, name);
        return e == null ? null : e.getAttribute(aname);
    }

    public static TransformerFactory newXXEProtectedTransformerFactory() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        return transformerFactory;
    }

    public static void writeDomToFile(Document doc, String filename) throws TransformerException, IOException {
        TransformerFactory transformerFactory = XMLUtil.newXXEProtectedTransformerFactory();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult streamResult = new StreamResult(ManagedFileAccess.file(filename));
        transformer.transform(source, streamResult);
    }

    public static String getXsiType(Element element) {
        Attr a = element.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
        return a == null ? null : a.getTextContent();
    }

    public static String getDirectText(Element node) {
        StringBuilder b = new StringBuilder();
        for (Node n = node.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 3) continue;
            b.append(n.getTextContent());
        }
        return b.toString().trim();
    }

    public static void deleteByName(Element e, String name) {
        List<Element> matches = XMLUtil.getNamedChildren(e, name);
        for (Element m : matches) {
            e.removeChild(m);
        }
    }

    public static void deleteAttr(Element e, String namespaceURI, String localName) {
        if (e.hasAttributeNS(namespaceURI, localName)) {
            e.removeAttributeNS(namespaceURI, localName);
        }
    }

    public static Node[] children(Element ed) {
        Node[] res = new Node[ed.getChildNodes().getLength()];
        for (int i = 0; i < ed.getChildNodes().getLength(); ++i) {
            res[i] = ed.getChildNodes().item(i);
        }
        return res;
    }

    public static Element addChild(Document doc, Element element, String name, String namespace, int indent) {
        Text node = doc.createTextNode("\n" + Utilities.padLeft("", ' ', indent));
        Element child = doc.createElementNS(namespace, name);
        element.appendChild(child);
        element.appendChild(node);
        return child;
    }

    public static Element insertChild(Document doc, Element element, String name, String namespace, int indent) {
        Text node = doc.createTextNode("\n" + Utilities.padLeft("", ' ', indent));
        Element child = doc.createElementNS(namespace, name);
        element.insertBefore(child, element.getFirstChild());
        element.insertBefore(node, element.getFirstChild());
        return child;
    }

    public static Element insertChild(Document doc, Element element, String name, String namespace, Node before, int indent) {
        if (before == null) {
            Text node = doc.createTextNode("\n" + Utilities.padLeft("", ' ', indent));
            element.insertBefore(node, before);
        }
        Element child = doc.createElementNS(namespace, name);
        element.insertBefore(child, before);
        if (before != null) {
            Text node = doc.createTextNode("\n" + Utilities.padLeft("", ' ', indent));
            element.insertBefore(node, before);
        }
        return child;
    }

    public static void addTextTag(Document doc, Element element, String name, String namespace, String text, int indent) {
        Text node = doc.createTextNode("\n" + Utilities.padLeft("", ' ', indent));
        element.appendChild(node);
        Element child = doc.createElementNS(namespace, name);
        element.appendChild(child);
        child.setAttribute("value", text);
    }

    public static Element addTextTag(Document doc, Element element, String name, String text, int indent) {
        Text node = doc.createTextNode("\n" + Utilities.padLeft("", ' ', indent));
        element.appendChild(node);
        Element child = doc.createElement(name);
        element.appendChild(child);
        child.appendChild(doc.createTextNode(text));
        return child;
    }

    public static void saveToFile(Element root, OutputStream stream) throws TransformerException {
        Transformer transformer = XMLUtil.newXXEProtectedTransformerFactory().newTransformer();
        StreamResult output = new StreamResult(stream);
        DOMSource input = new DOMSource(root);
        transformer.transform(input, output);
    }

    public static void spacer(Document doc, Element element, int indent) {
        Text node = doc.createTextNode("\n" + Utilities.padLeft("", ' ', indent));
        element.appendChild(node);
    }

    public static String getNamedChildText(Element element, String name) {
        Element e = XMLUtil.getNamedChild(element, name);
        return e == null ? null : e.getTextContent();
    }

    public static Element getFirstChild(Element res, String ... names) {
        Element node = XMLUtil.getFirstChild(res);
        while (node != null && !Utilities.existsInList(node.getLocalName(), names)) {
            node = XMLUtil.getNextSibling(node);
        }
        return node;
    }

    public static Element getLastChild(Element res, String ... names) {
        Element result = null;
        Element node = XMLUtil.getFirstChild(res);
        while (node != null) {
            if (Utilities.existsInList(node.getLocalName(), names)) {
                result = node;
            }
            node = XMLUtil.getNextSibling(node);
        }
        return result;
    }

    public static void clearChildren(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = nodeList.getLength() - 1; i >= 0; --i) {
            Node item = nodeList.item(i);
            if (item.hasChildNodes()) {
                XMLUtil.clearChildren(item);
            }
            node.removeChild(item);
        }
    }
}

