/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.graphql;

import org.hl7.fhir.utilities.graphql.Value;

public class StringValue
extends Value {
    private String value;

    public StringValue(String value) {
        this.value = value;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean isValue(String v) {
        return v.equals(this.value);
    }

    public String toString() {
        return this.value;
    }

    @Override
    public void write(StringBuilder b, int indent) {
        b.append("\"");
        for (char ch : this.value.toCharArray()) {
            if (ch == '\"') {
                b.append("\\\"");
                continue;
            }
            if (ch == '\\') {
                b.append("\\\\");
                continue;
            }
            if (ch == '\r') {
                b.append("\\r");
                continue;
            }
            if (ch == '\n') {
                b.append("\\n");
                continue;
            }
            if (ch == '\t') {
                b.append("\\t");
                continue;
            }
            if (ch < ' ') {
                b.append("\\u" + Integer.toHexString(ch));
                continue;
            }
            b.append(ch);
        }
        b.append("\"");
    }
}

