/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.i18n;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class RegionToLocaleMapper {
    static final Map<String, Locale> codeToLocale = new HashMap<String, Locale>();

    private RegionToLocaleMapper() {
        throw new IllegalStateException("Utility class");
    }

    private static void addLocaleForRegions(Locale locale, String ... regions) {
        for (String region : regions) {
            codeToLocale.put(region, locale);
        }
    }

    public static Locale getLocaleFromRegion(String countryCode) {
        return codeToLocale.get(countryCode);
    }

    static {
        RegionToLocaleMapper.addLocaleForRegions(new Locale("es", "AR"), "AR", "ARG");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("en", "AU"), "AU", "AUS");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("de", "AT"), "AT", "AUT");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("pt", "BR"), "BR", "BRA");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("es", "CL"), "CL", "CHL");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("zh", "CN"), "CN", "CHN");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("es", "CO"), "CO", "COL");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("hr", "HR"), "HR", "HRV");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("cz", "CZ"), "CZ", "CZE");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("da", "DK"), "DK", "DNK");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("fi", "FI"), "FI", "FIN");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("fr", "FR"), "FR", "FRA");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("de", "DE"), "DE", "DEU");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("el", "GR"), "GR", "GRC");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("zh", "HK"), "HK", "HKG");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("hi", "IN"), "IN", "IND");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("it", "IT"), "IT", "ITA");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("ja", "JP"), "JP", "JPN");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("ko", "KR"), "KR", "KOR");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("es", "MX"), "MX", "MEX");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("nl", "NL"), "NL", "NLD");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("en", "NZ"), "NZ", "NZL");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("no", "NO"), "NO", "NOR");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("es", "PE"), "PE", "PER");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("es", "PH"), "PH", "PHL");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("pl", "PL"), "PL", "POL");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("pt", "PT"), "PT", "PRT");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("hu", "RO"), "RO", "ROU");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("ru", "RU"), "RU", "RUS");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("en", "SG"), "SG", "SGP");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("sk", "SK"), "SK", "SVK");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("sl", "SI"), "SI", "SVN");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("es", "ES"), "ES", "ESP");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("sv", "SE"), "SE", "SWE");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("zh", "TW"), "TW", "TWN");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("ar", "AE"), "AE", "ARE");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("en", "GB"), "GB", "GBR");
        RegionToLocaleMapper.addLocaleForRegions(new Locale("uk", "UA"), "UA", "UKR");
    }
}

