/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.utilities.http.HTTPResult;
import org.hl7.fhir.utilities.http.ManagedWebAccessBuilder;
import org.hl7.fhir.utilities.settings.ServerDetailsPOJO;

public class ManagedWebAccess {
    private static WebAccessPolicy accessPolicy = WebAccessPolicy.DIRECT;
    private static List<String> allowedDomains = new ArrayList<String>();
    private static IWebAccessor accessor;
    private static String userAgent;
    private static List<ServerDetailsPOJO> serverAuthDetails;

    public static WebAccessPolicy getAccessPolicy() {
        return accessPolicy;
    }

    public static void setAccessPolicy(WebAccessPolicy accessPolicy) {
        ManagedWebAccess.accessPolicy = accessPolicy;
    }

    static boolean inAllowedPaths(String pathname) {
        if (allowedDomains.isEmpty()) {
            return true;
        }
        for (String s : allowedDomains) {
            if (!pathname.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    public static String getUserAgent() {
        return userAgent;
    }

    public static void setUserAgent(String userAgent) {
        ManagedWebAccess.userAgent = userAgent;
    }

    public static IWebAccessor getAccessor() {
        return accessor;
    }

    public static ManagedWebAccessBuilder builder() {
        return new ManagedWebAccessBuilder(userAgent, serverAuthDetails);
    }

    public static HTTPResult get(String url) throws IOException {
        return ManagedWebAccess.builder().get(url);
    }

    public static HTTPResult get(String url, String accept) throws IOException {
        return ManagedWebAccess.builder().withAccept(accept).get(url);
    }

    public static HTTPResult post(String url, byte[] content, String contentType, String accept) throws IOException {
        return ManagedWebAccess.builder().withAccept(accept).post(url, content, contentType);
    }

    public static HTTPResult put(String url, byte[] content, String contentType, String accept) throws IOException {
        return ManagedWebAccess.builder().withAccept(accept).put(url, content, contentType);
    }

    public static enum WebAccessPolicy {
        DIRECT,
        MANAGED,
        PROHIBITED;

    }

    public static interface IWebAccessor {
        public HTTPResult get(String var1, String var2, Map<String, String> var3) throws IOException;

        public HTTPResult post(String var1, byte[] var2, String var3, String var4, Map<String, String> var5) throws IOException;

        public HTTPResult put(String var1, byte[] var2, String var3, String var4, Map<String, String> var5) throws IOException;
    }
}

