/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.tests;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.tests.TestConfig;

public class CacheVerificationLogger
implements ToolingClientLogger {
    int requests = 0;

    @Override
    public void logRequest(String method, String url, List<String> headers, byte[] body) {
        if (!TestConfig.getInstance().isRebuildCache()) {
            System.err.println("Unexpected request to server");
            System.err.println(method);
            System.err.println(url);
            if (headers != null) {
                for (String header : headers) {
                    System.err.println("Header: " + header);
                }
            }
            if (body != null) {
                System.err.println("Body");
                System.err.println("----");
                System.err.println(new String(body, StandardCharsets.UTF_8));
            }
        }
        ++this.requests;
    }

    @Override
    public void logResponse(String outcome, List<String> headers, byte[] body, long start) {
    }

    @Override
    public String getLastId() {
        return null;
    }

    @Override
    public void clearLastId() {
    }

    public boolean verifyHasNoRequests() {
        if (TestConfig.getInstance().isRebuildCache()) {
            return true;
        }
        if (this.requests != 0) {
            System.err.println(this.requests + " unexpected TX server requests logged. If a new test has been added, you may need to rebuild the TX Cache for the test using the 'mvn test -Dfhir.txcache.rebuild=true' option");
            return false;
        }
        return true;
    }

    public int getRequests() {
        return this.requests;
    }
}

