/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.http;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.http.HTTPHeader;
import org.hl7.fhir.utilities.http.HTTPResultException;
import org.hl7.fhir.utilities.http.SimpleHTTPClient;

public class HTTPResult {
    private final int code;
    private final String contentType;
    private final byte[] content;
    private final String source;
    private final String message;
    private final Iterable<HTTPHeader> headers;

    public HTTPResult(String source, int code, String message, String contentType, byte[] content) {
        this(source, code, message, contentType, content, Collections.emptyList());
    }

    public HTTPResult(String source, int code, String message, String contentType, byte[] content, Iterable<HTTPHeader> headers) {
        this.source = source;
        this.code = code;
        this.contentType = contentType;
        this.content = content;
        this.message = message;
        this.headers = headers;
    }

    public void checkThrowException() throws IOException {
        if (this.code >= 300) {
            String filename = Utilities.path("[tmp]", "http-log", "fhir-http-" + SimpleHTTPClient.nextCounter() + ".log");
            if (this.content == null || this.content.length == 0) {
                HTTPResultException exception = new HTTPResultException(this.code, this.message, this.source, null);
                throw new IOException(exception.message, exception);
            }
            Utilities.createDirectory(Utilities.path("[tmp]", "http-log"));
            TextFile.bytesToFile(this.content, filename);
            HTTPResultException exception = new HTTPResultException(this.code, this.message, this.source, filename);
            throw new IOException(exception.message, exception);
        }
    }

    public String getContentAsString() {
        return new String(this.content, StandardCharsets.UTF_8);
    }

    public int getCode() {
        return this.code;
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getSource() {
        return this.source;
    }

    public String getMessage() {
        return this.message;
    }

    public Iterable<HTTPHeader> getHeaders() {
        return this.headers;
    }
}

