/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.http;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.utilities.http.HTTPAuthenticationMode;
import org.hl7.fhir.utilities.settings.ServerDetailsPOJO;

public abstract class ManagedWebAccessorBase<B extends ManagedWebAccessorBase<B>> {
    private final Iterable<String> serverTypes;
    private final String userAgent;
    private HTTPAuthenticationMode authenticationMode;
    private String username;
    private String password;
    private String token;
    private final List<ServerDetailsPOJO> serverAuthDetails;
    private final Map<String, String> headers = new HashMap<String, String>();

    public ManagedWebAccessorBase(Iterable<String> serverTypes, String userAgent, List<ServerDetailsPOJO> serverAuthDetails) {
        this.serverTypes = serverTypes;
        this.userAgent = userAgent;
        this.serverAuthDetails = serverAuthDetails;
    }

    final B self() {
        return (B)this;
    }

    public B withHeader(String name, String value) {
        this.headers.put(name, value);
        return this.self();
    }

    public B withBasicAuth(String username, String password) {
        this.authenticationMode = HTTPAuthenticationMode.BASIC;
        this.username = username;
        this.password = password;
        return this.self();
    }

    public B withToken(String token) {
        this.authenticationMode = HTTPAuthenticationMode.TOKEN;
        this.token = token;
        return this.self();
    }

    public B withApiKey(String apiKey) {
        this.authenticationMode = HTTPAuthenticationMode.APIKEY;
        this.token = apiKey;
        return this.self();
    }

    public B withNoneAuth() {
        this.authenticationMode = HTTPAuthenticationMode.NONE;
        this.setAllAuthHeadersToNull();
        return this.self();
    }

    public B withServerSpecificAuth() {
        this.authenticationMode = null;
        this.setAllAuthHeadersToNull();
        return this.self();
    }

    private void setAllAuthHeadersToNull() {
        this.token = null;
        this.username = null;
        this.password = null;
    }

    public Iterable<String> getServerTypes() {
        return this.serverTypes;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public HTTPAuthenticationMode getAuthenticationMode() {
        return this.authenticationMode;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getToken() {
        return this.token;
    }

    public List<ServerDetailsPOJO> getServerAuthDetails() {
        return this.serverAuthDetails;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

