/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xls;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XLSXmlNormaliser {
    private static final String XLS_NS = "urn:schemas-microsoft-com:office:spreadsheet";
    private Document xml;
    private String source;
    private String dest;
    private boolean exceptionIfExcelNotNormalised;

    public XLSXmlNormaliser(String source, String dest, boolean exceptionIfExcelNotNormalised) {
        this.source = source;
        this.dest = dest;
        this.exceptionIfExcelNotNormalised = exceptionIfExcelNotNormalised;
    }

    public XLSXmlNormaliser(String source, boolean exceptionIfExcelNotNormalised) {
        this.source = source;
        this.dest = source;
        this.exceptionIfExcelNotNormalised = exceptionIfExcelNotNormalised;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go() throws FHIRException, TransformerException, ParserConfigurationException, SAXException, IOException {
        File inp = ManagedFileAccess.file(this.source);
        long time = inp.lastModified();
        this.xml = this.parseXml(ManagedFileAccess.inStream(inp));
        Element root = this.xml.getDocumentElement();
        boolean hasComment = false;
        for (Node n = root.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 8 || !"canonicalized".equals(n.getTextContent())) continue;
            hasComment = true;
            break;
        }
        if (hasComment) {
            return;
        }
        if (this.exceptionIfExcelNotNormalised) {
            throw new FHIRException("The spreadsheet " + this.dest + " was committed after editing in excel, but before the build could run *after Excel was closed*");
        }
        System.out.println("normalise: " + this.source);
        XMLUtil.deleteByName(root, "ActiveSheet");
        Element xw = XMLUtil.getNamedChild(root, "ExcelWorkbook");
        XMLUtil.deleteByName(xw, "WindowHeight");
        XMLUtil.deleteByName(xw, "WindowWidth");
        XMLUtil.deleteByName(xw, "WindowTopX");
        XMLUtil.deleteByName(xw, "WindowTopY");
        for (Element wk : XMLUtil.getNamedChildren(root, "Worksheet")) {
            this.processWorksheet(wk);
        }
        if (!hasComment) {
            root.appendChild(this.xml.createComment("canonicalized"));
        }
        try {
            try (FileOutputStream fs = ManagedFileAccess.outStream(this.dest);){
                this.saveXml(fs);
            }
            String s = TextFile.fileToString(this.dest);
            s = s.replaceAll("\r\n", "\n");
            s = this.replaceSignificantEoln(s);
            TextFile.stringToFile(s, this.dest);
            ManagedFileAccess.file(this.dest).setLastModified(time);
        }
        catch (Exception e) {
            System.out.println("The file " + this.dest + " is still open in Excel, and you will have to run the build after closing Excel before committing");
        }
    }

    private String replaceSignificantEoln(String s) {
        StringBuilder b = new StringBuilder();
        boolean hasText = false;
        for (char c : s.toCharArray()) {
            if (c == '>' || c == '<') {
                hasText = false;
                b.append(c);
                continue;
            }
            if (c == '\n') {
                if (hasText) {
                    b.append("&#10;");
                    continue;
                }
                b.append(c);
                continue;
            }
            if (!Character.isWhitespace(c)) {
                b.append(c);
                hasText = true;
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    private void processWorksheet(Element wk) throws FHIRException {
        Element tbl = XMLUtil.getNamedChild(wk, "Table");
        this.processTable(tbl);
        for (Element row : XMLUtil.getNamedChildren(tbl, "Row")) {
            this.processRow(row);
        }
        for (Element col : XMLUtil.getNamedChildren(tbl, "Column")) {
            this.processCol(col);
        }
        for (Element wo : XMLUtil.getNamedChildren(wk, "WorksheetOptions")) {
            this.processOptions(wo);
        }
    }

    private void processOptions(Element wo) {
        XMLUtil.deleteByName(wo, "Unsynced");
        XMLUtil.deleteByName(wo, "Panes");
        for (Element panes : XMLUtil.getNamedChildren(wo, "Panes")) {
            this.processPanes(panes);
        }
    }

    private void processPanes(Element panes) {
        for (Element pane : XMLUtil.getNamedChildren(panes, "Pane")) {
            this.processPane(pane);
        }
    }

    private void processPane(Element pane) {
        XMLUtil.deleteByName(pane, "ActiveRow");
        XMLUtil.deleteByName(pane, "ActiveCol");
    }

    private void processTable(Element col) {
        XMLUtil.deleteAttr(col, XLS_NS, "DefaultColumnWidth");
        XMLUtil.deleteAttr(col, XLS_NS, "DefaultRowHeight");
    }

    private void processCol(Element col) {
        String width = col.getAttributeNS(XLS_NS, "Width");
        if (!Utilities.noString(width)) {
            Double d = Double.valueOf(width);
            width = Double.toString(Math.round(d * 2.0) / 2L);
            col.setAttributeNS(XLS_NS, "ss:Width", width);
        }
    }

    private void processRow(Element row) {
        String height = row.getAttributeNS(XLS_NS, "Height");
        if (!Utilities.noString(height) && height.contains(".")) {
            Double d = Double.valueOf(height);
            row.setAttributeNS(XLS_NS, "ss:Height", Long.toString(Math.round(d)));
        }
    }

    private void check(boolean test, String message) throws FHIRException {
        if (!test) {
            throw new FHIRException(message + " in " + this.getLocation());
        }
    }

    private Document parseXml(InputStream in) throws FHIRException, ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = XMLUtil.newXXEProtectedDocumentBuilderFactory();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(in);
    }

    private void saveXml(FileOutputStream stream) throws TransformerException, IOException {
        TransformerFactory factory = XMLUtil.newXXEProtectedTransformerFactory();
        Transformer transformer = factory.newTransformer();
        StreamResult result = new StreamResult(stream);
        DOMSource source = new DOMSource(this.xml);
        transformer.transform(source, result);
        stream.flush();
    }

    private String getLocation() {
        return this.source;
    }
}

