/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.utilities.TextStreamWriter;
import org.hl7.fhir.utilities.Utilities;

public class SchematronWriter
extends TextStreamWriter {
    private SchematronType type;
    private String description;
    private List<Section> sections = new ArrayList<Section>();

    public SchematronWriter(OutputStream out, SchematronType type, String description) throws UnsupportedEncodingException {
        super(out);
        this.type = type;
        this.description = description;
    }

    public Section section(String title) {
        for (Section s : this.sections) {
            if (!s.title.equals(title)) continue;
            return s;
        }
        Section s = new Section();
        s.title = title;
        this.sections.add(s);
        return s;
    }

    public void dump() throws IOException {
        this.ln("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.ln_i("<sch:schema xmlns:sch=\"http://purl.oclc.org/dsdl/schematron\" queryBinding=\"xslt2\">");
        this.ln("<sch:ns prefix=\"f\" uri=\"http://hl7.org/fhir\"/>");
        this.ln("<sch:ns prefix=\"h\" uri=\"http://www.w3.org/1999/xhtml\"/>");
        this.addNote();
        for (Section s : this.sections) {
            if (s.hasRegularContent()) {
                this.ln_i("<sch:pattern>");
                this.ln("<sch:title>" + Utilities.escapeXml(s.title) + "</sch:title>");
                for (Rule r : s.getRegularRules()) {
                    if (r.asserts.isEmpty()) continue;
                    this.ln_i("<sch:rule context=\"" + Utilities.escapeXml(r.name) + "\">");
                    for (Assert a : r.asserts) {
                        this.ln("<sch:assert test=\"" + Utilities.escapeXml(a.test) + "\">" + Utilities.escapeXml(a.message) + "</sch:assert>");
                    }
                    this.ln_o("</sch:rule>");
                }
                this.ln_o("</sch:pattern>");
            }
            if (!s.hasSpecialContent()) continue;
            int i = 1;
            for (Rule r : s.getSpecialRules()) {
                this.ln_i("<sch:pattern>");
                this.ln("<sch:title>" + Utilities.escapeXml(s.title) + " " + i + "</sch:title>");
                ++i;
                if (!r.asserts.isEmpty()) {
                    this.ln_i("<sch:rule context=\"" + Utilities.escapeXml(r.name) + "\">");
                    for (Assert a : r.asserts) {
                        this.ln("<sch:assert test=\"" + Utilities.escapeXml(a.test) + "\">" + Utilities.escapeXml(a.message) + "</sch:assert>");
                    }
                    this.ln_o("</sch:rule>");
                }
                this.ln_o("</sch:pattern>");
            }
        }
        this.ln_o("</sch:schema>");
        this.flush();
        this.close();
    }

    private void addNote() throws IOException {
        switch (this.type) {
            case ALL_RESOURCES: {
                this.addAllResourcesNote();
                break;
            }
            case RESOURCE: {
                this.addResourceNote();
                break;
            }
            case PROFILE: {
                this.addProfileNote();
            }
        }
    }

    private void addAllResourcesNote() throws IOException {
        this.ln("<!-- ");
        this.ln("  This file contains constraints for all resources");
        this.ln("  Because of the way containment works, this file should always ");
        this.ln("  be used for validating resources. Alternatively you can use ");
        this.ln("  the resource specific files to build a smaller version of");
        this.ln("  this file (the contents are identical; only include those ");
        this.ln("  resources relevant to your implementation).");
        this.ln("-->");
    }

    private void addResourceNote() throws IOException {
        this.ln("<!-- ");
        this.ln("  This file contains just the constraints for the resource " + this.description);
        this.ln("  It is provided for documentation purposes. When actually validating,");
        this.ln("  always use fhir-invariants.sch (because of the way containment works)");
        this.ln("  Alternatively you can use this file to build a smaller version of");
        this.ln("  fhir-invariants.sch (the contents are identical; only include those ");
        this.ln("  resources relevant to your implementation).");
        this.ln("-->");
    }

    private void addProfileNote() throws IOException {
        this.ln("<!-- ");
        this.ln("  This file contains just the constraints for the profile " + this.description);
        this.ln("  It includes the base constraints for the resource as well.");
        this.ln("  Because of the way that schematrons and containment work, ");
        this.ln("  you may need to use this schematron fragment to build a, ");
        this.ln("  single schematron that validates contained resources (if you have any) ");
        this.ln("-->");
    }

    public class Section {
        private String title;
        private List<Rule> rules = new ArrayList<Rule>();

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public Rule rule(String name) {
            for (Rule r : this.rules) {
                if (!r.name.equals(name)) continue;
                return r;
            }
            Rule r = new Rule();
            r.name = name;
            this.rules.add(r);
            return r;
        }

        public boolean hasRegularContent() {
            for (Rule r : this.rules) {
                if (r.asserts.isEmpty() || r.isSpecial()) continue;
                return true;
            }
            return false;
        }

        public boolean hasSpecialContent() {
            for (Rule r : this.rules) {
                if (r.asserts.isEmpty() || !r.isSpecial()) continue;
                return true;
            }
            return false;
        }

        public List<Rule> getRegularRules() {
            ArrayList<Rule> regular = new ArrayList<Rule>();
            for (Rule r : this.rules) {
                if (r.asserts.isEmpty() || r.isSpecial()) continue;
                regular.add(r);
            }
            return regular;
        }

        public List<Rule> getSpecialRules() {
            ArrayList<Rule> regular = new ArrayList<Rule>();
            for (Rule r : this.rules) {
                if (r.asserts.isEmpty() || !r.isSpecial()) continue;
                regular.add(r);
            }
            return regular;
        }
    }

    public class Rule {
        private String name;
        private List<Assert> asserts = new ArrayList<Assert>();

        public void assrt(String test, String message) {
            Assert a = new Assert();
            a.test = test;
            a.message = message;
            this.asserts.add(a);
        }

        public boolean isSpecial() {
            return this.name.contains("*") || this.name.contains("[");
        }
    }

    public class Assert {
        private String test;
        private String message;
    }

    public static enum SchematronType {
        ALL_RESOURCES,
        RESOURCE,
        PROFILE;

    }
}

