/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.http;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.utilities.http.HTTPHeader;

public class HTTPHeaderUtil {
    public static final String USER_AGENT = "User-Agent";

    public static Map<String, List<String>> getMultimap(Iterable<HTTPHeader> headers) {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (headers != null) {
            for (HTTPHeader header : headers) {
                List values = result.getOrDefault(header.getName(), new ArrayList());
                values.add(header.getValue());
                result.put(header.getName(), values);
            }
        }
        return result;
    }

    public static Iterable<String> getHeaders(Iterable<HTTPHeader> headers, String key) {
        ArrayList<String> result = new ArrayList<String>();
        if (headers != null) {
            for (HTTPHeader header : headers) {
                if (!header.getName().equalsIgnoreCase(key)) continue;
                result.add(header.getValue());
            }
        }
        return result;
    }

    public static String getSingleHeader(Iterable<HTTPHeader> headers, String key) {
        for (HTTPHeader header : headers) {
            if (!header.getName().equalsIgnoreCase(key)) continue;
            return header.getValue();
        }
        return null;
    }
}

