/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.http;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.utilities.http.HTTPAuthenticationMode;
import org.hl7.fhir.utilities.http.HTTPResult;
import org.hl7.fhir.utilities.http.ManagedWebAccess;
import org.hl7.fhir.utilities.http.ManagedWebAccessUtils;
import org.hl7.fhir.utilities.http.ManagedWebAccessorBase;
import org.hl7.fhir.utilities.http.SimpleHTTPClient;
import org.hl7.fhir.utilities.settings.ServerDetailsPOJO;

public class ManagedWebAccessor
extends ManagedWebAccessorBase<ManagedWebAccessor> {
    public ManagedWebAccessor(Iterable<String> serverTypes, String userAgent, List<ServerDetailsPOJO> serverAuthDetails) {
        super(serverTypes, userAgent, serverAuthDetails);
    }

    private Map<String, String> newHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>(this.getHeaders());
        if (this.getAuthenticationMode() == HTTPAuthenticationMode.TOKEN) {
            headers.put("Authorization", "Bearer " + this.getToken());
        } else if (this.getAuthenticationMode() == HTTPAuthenticationMode.BASIC) {
            String auth = this.getUsername() + ":" + this.getPassword();
            byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.UTF_8));
            headers.put("Authorization", "Basic " + new String(encodedAuth));
        } else if (this.getAuthenticationMode() == HTTPAuthenticationMode.APIKEY) {
            headers.put("Api-Key", this.getToken());
        }
        if (this.getUserAgent() != null) {
            headers.put("User-Agent", this.getUserAgent());
        }
        return headers;
    }

    private SimpleHTTPClient setupClient(String url) throws IOException {
        if (!ManagedWebAccess.inAllowedPaths(url)) {
            throw new IOException("The pathname '" + url + "' cannot be accessed by policy");
        }
        SimpleHTTPClient client = new SimpleHTTPClient();
        for (Map.Entry<String, String> entry : this.getHeaders().entrySet()) {
            client.addHeader(entry.getKey(), entry.getValue());
        }
        if (this.getUserAgent() != null) {
            client.addHeader("User-Agent", this.getUserAgent());
        }
        if (this.getAuthenticationMode() != null) {
            if (this.getAuthenticationMode() != HTTPAuthenticationMode.NONE) {
                client.setAuthenticationMode(this.getAuthenticationMode());
                switch (this.getAuthenticationMode()) {
                    case BASIC: {
                        client.setUsername(this.getUsername());
                        client.setPassword(this.getPassword());
                        break;
                    }
                    case TOKEN: {
                        client.setToken(this.getToken());
                        break;
                    }
                    case APIKEY: {
                        client.setApiKey(this.getToken());
                    }
                }
            }
        } else {
            ServerDetailsPOJO settings = ManagedWebAccessUtils.getServer(this.getServerTypes(), url, this.getServerAuthDetails());
            if (settings != null) {
                switch (settings.getAuthenticationType()) {
                    case "basic": {
                        client.setUsername(settings.getUsername());
                        client.setPassword(settings.getPassword());
                        client.setAuthenticationMode(HTTPAuthenticationMode.BASIC);
                        break;
                    }
                    case "token": {
                        client.setToken(settings.getToken());
                        client.setAuthenticationMode(HTTPAuthenticationMode.TOKEN);
                        break;
                    }
                    case "apikey": {
                        client.setApiKey(settings.getApikey());
                        client.setAuthenticationMode(HTTPAuthenticationMode.APIKEY);
                    }
                }
            }
        }
        if (this.getUsername() != null || this.getToken() != null) {
            client.setAuthenticationMode(this.getAuthenticationMode());
        }
        return client;
    }

    public HTTPResult get(String url) throws IOException {
        return this.get(url, null);
    }

    public HTTPResult get(String url, String accept) throws IOException {
        switch (ManagedWebAccess.getAccessPolicy()) {
            case DIRECT: {
                SimpleHTTPClient client = this.setupClient(url);
                return client.get(url, accept);
            }
            case MANAGED: {
                return ManagedWebAccess.getAccessor().get(this.getServerTypes(), url, accept, this.newHeaders());
            }
            case PROHIBITED: {
                throw new IOException("Access to the internet is not allowed by local security policy");
            }
        }
        throw new IOException("Internal Error");
    }

    public HTTPResult post(String url, byte[] content, String contentType) throws IOException {
        return this.post(url, content, contentType, null);
    }

    public HTTPResult post(String url, byte[] content, String contentType, String accept) throws IOException {
        switch (ManagedWebAccess.getAccessPolicy()) {
            case DIRECT: {
                SimpleHTTPClient client = this.setupClient(url);
                return client.post(url, contentType, content, accept);
            }
            case MANAGED: {
                return ManagedWebAccess.getAccessor().post(this.getServerTypes(), url, content, contentType, accept, this.newHeaders());
            }
            case PROHIBITED: {
                throw new IOException("Access to the internet is not allowed by local security policy");
            }
        }
        throw new IOException("Internal Error");
    }

    public HTTPResult put(String url, byte[] content, String contentType) throws IOException {
        return this.put(url, content, contentType, null);
    }

    public HTTPResult put(String url, byte[] content, String contentType, String accept) throws IOException {
        switch (ManagedWebAccess.getAccessPolicy()) {
            case DIRECT: {
                SimpleHTTPClient client = this.setupClient(url);
                return client.put(url, contentType, content, accept);
            }
            case MANAGED: {
                return ManagedWebAccess.getAccessor().put(this.getServerTypes(), url, content, contentType, accept, this.newHeaders());
            }
            case PROHIBITED: {
                throw new IOException("Access to the internet is not allowed by local security policy");
            }
        }
        throw new IOException("Internal Error");
    }
}

