/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.logging;

import java.io.IOException;
import javax.annotation.Nonnull;

public class ManagedLogging {
    private static LoggingPolicy logPolicy = LoggingPolicy.CONSOLE;
    private static ILoggingProvider provider;

    public static LoggingPolicy getLogPolicy() {
        return logPolicy;
    }

    public static void setLogPolicy(@Nonnull LoggingPolicy logPolicy) {
        ManagedLogging.logPolicy = logPolicy;
    }

    public static ILoggingProvider getProvider() {
        return provider;
    }

    public static void setProvider(ILoggingProvider provider) {
        ManagedLogging.provider = provider;
    }

    public static void log(String message) throws IOException {
        switch (logPolicy) {
            case CONSOLE: {
                System.out.println(message);
            }
            case CUSTOM: {
                if (provider != null) {
                    provider.log(message);
                }
            }
            case IGNORED: {
                break;
            }
            case LOG4J: {
                break;
            }
            default: {
                throw new Error("LogPolicy is not valid ");
            }
        }
    }

    public static enum LoggingPolicy {
        CONSOLE,
        IGNORED,
        LOG4J,
        CUSTOM;

    }

    public static interface ILoggingProvider {
        public void log(String var1);
    }
}

