/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.llp;

import ca.uhn.hl7v2.hoh.api.IAuthorizationClientCallback;
import ca.uhn.hl7v2.hoh.api.IAuthorizationServerCallback;
import ca.uhn.hl7v2.hoh.llp.HohLlpReader;
import ca.uhn.hl7v2.hoh.llp.HohLlpWriter;
import ca.uhn.hl7v2.hoh.sign.ISigner;
import ca.uhn.hl7v2.hoh.util.ServerRoleEnum;
import ca.uhn.hl7v2.llp.HL7Reader;
import ca.uhn.hl7v2.llp.HL7Writer;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class Hl7OverHttpLowerLayerProtocol
extends LowerLayerProtocol {
    private final ServerRoleEnum myRole;
    private IAuthorizationClientCallback myAuthorizationClientCallback;
    private IAuthorizationServerCallback myAuthorizationServerCallback;
    private HohLlpReader myNextReader;
    private HohLlpWriter myNextWriter;
    private ISigner mySigner;
    private String myUriPath = "/";
    private Charset myPreferredCharset;
    private String myHost;

    public Hl7OverHttpLowerLayerProtocol(ServerRoleEnum theRole) {
        this.myRole = theRole;
        if (this.myRole == null) {
            throw new NullPointerException("Role can not be null");
        }
    }

    IAuthorizationClientCallback getAuthorizationClientCallback() {
        return this.myAuthorizationClientCallback;
    }

    IAuthorizationServerCallback getAuthorizationServerCallback() {
        return this.myAuthorizationServerCallback;
    }

    public HL7Reader getReader(InputStream theArg0) throws LLPException {
        if (this.myNextReader == null && this.myNextWriter != null) {
            this.myNextWriter = null;
            throw new LLPException("Hl7OverHttpLowerLayerProtocol can not be used with a multi socket implementation");
        }
        this.prepareReadersIfNeeded();
        HohLlpReader retVal = this.myNextReader;
        try {
            retVal.setInputStream(theArg0);
        }
        catch (IOException e) {
            throw new LLPException("Failed to set stream: " + e.getMessage(), (Exception)e);
        }
        this.myNextReader = null;
        return retVal;
    }

    public ServerRoleEnum getRole() {
        return this.myRole;
    }

    ISigner getSigner() {
        return this.mySigner;
    }

    public void setSigner(ISigner theSigner) {
        this.mySigner = theSigner;
    }

    public String getUriPath() {
        return this.myUriPath;
    }

    public void setUriPath(String theUriPath) {
        this.myUriPath = theUriPath;
    }

    public String getHost() {
        return this.myHost;
    }

    public void setHost(String thehost) {
        this.myHost = thehost;
    }

    public HL7Writer getWriter(OutputStream theArg0) throws LLPException {
        if (this.myNextReader != null && this.myNextWriter == null) {
            this.myNextReader = null;
            throw new LLPException("Hl7OverHttpLowerLayerProtocol can not be used with a multi socket implementation");
        }
        this.prepareReadersIfNeeded();
        HohLlpWriter retVal = this.myNextWriter;
        retVal.setPreferredCharset(this.myPreferredCharset);
        try {
            retVal.setOutputStream(theArg0);
        }
        catch (IOException e) {
            throw new LLPException("Failed to set stream: " + e.getMessage(), (Exception)e);
        }
        this.myNextWriter = null;
        return retVal;
    }

    private void prepareReadersIfNeeded() {
        if (this.myNextReader == null && this.myNextWriter == null) {
            this.myNextReader = new HohLlpReader(this);
            this.myNextWriter = new HohLlpWriter(this);
            this.myNextReader.setWriter(this.myNextWriter);
        }
    }

    public void setAuthorizationCallback(IAuthorizationClientCallback theAuthorizationClientCallback) {
        if (this.myRole == ServerRoleEnum.SERVER) {
            throw new IllegalStateException("This LLP implementation is in CLIENT mode, so it can not use an authorization callback");
        }
        this.myAuthorizationClientCallback = theAuthorizationClientCallback;
    }

    public void setAuthorizationCallback(IAuthorizationServerCallback theAuthorizationCallback) {
        if (this.myRole == ServerRoleEnum.CLIENT) {
            throw new IllegalStateException("This LLP implementation is in CLIENT mode, so it can not use an authorization callback");
        }
        this.myAuthorizationServerCallback = theAuthorizationCallback;
    }

    public void setPreferredCharset(Charset thePreferredCharset) {
        this.myPreferredCharset = thePreferredCharset;
    }
}

