/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.raw.client;

import ca.uhn.hl7v2.hoh.api.DecodeException;
import ca.uhn.hl7v2.hoh.api.EncodeException;
import ca.uhn.hl7v2.hoh.api.IAuthorizationClientCallback;
import ca.uhn.hl7v2.hoh.api.IClient;
import ca.uhn.hl7v2.hoh.api.IReceivable;
import ca.uhn.hl7v2.hoh.api.ISendable;
import ca.uhn.hl7v2.hoh.api.MessageMetadataKeys;
import ca.uhn.hl7v2.hoh.encoder.Hl7OverHttpRequestEncoder;
import ca.uhn.hl7v2.hoh.encoder.Hl7OverHttpResponseDecoder;
import ca.uhn.hl7v2.hoh.encoder.NoMessageReceivedException;
import ca.uhn.hl7v2.hoh.raw.api.RawReceivable;
import ca.uhn.hl7v2.hoh.raw.client.HohRawClientSimple;
import ca.uhn.hl7v2.hoh.sign.ISigner;
import ca.uhn.hl7v2.hoh.sign.SignatureVerificationException;
import ca.uhn.hl7v2.hoh.sockets.ISocketFactory;
import ca.uhn.hl7v2.hoh.sockets.StandardSocketFactory;
import ca.uhn.hl7v2.hoh.sockets.TlsSocketFactory;
import ca.uhn.hl7v2.hoh.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRawClient
implements IClient {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    public static final int DEFAULT_RESPONSE_TIMEOUT = 60000;
    private static final StandardSocketFactory DEFAULT_SOCKET_FACTORY = new StandardSocketFactory();
    private static final Logger ourLog = LoggerFactory.getLogger(HohRawClientSimple.class);
    private IAuthorizationClientCallback myAuthorizationCallback;
    private Charset myCharset = DEFAULT_CHARSET;
    private String myHost;
    private BufferedInputStream myInputStream;
    private boolean myKeepAlive = true;
    private OutputStream myOutputStream;
    private String myPath;
    private int myPort;
    private long myResponseTimeout = 60000L;
    private ISigner mySigner;
    private ISocketFactory mySocketFactory = DEFAULT_SOCKET_FACTORY;
    private int mySoTimeout = 5000;
    private URL myUrl;

    public AbstractRawClient() {
    }

    public AbstractRawClient(String theHost, int thePort, String thePath) {
        this.setHost(theHost);
        this.setPort(thePort);
        this.setUriPath(thePath);
    }

    public AbstractRawClient(URL theUrl) {
        this.setUrl(theUrl);
    }

    protected void closeSocket(Socket theSocket) {
        ourLog.debug("Closing socket");
        try {
            theSocket.close();
        }
        catch (IOException e) {
            ourLog.warn("Problem closing socket", (Throwable)e);
        }
    }

    protected Socket connect() throws IOException {
        ourLog.debug("Creating new connection to {}:{} for URI {}", new Object[]{this.myHost, this.myPort, this.myPath});
        Socket socket = this.mySocketFactory.createClientSocket();
        socket.connect(new InetSocketAddress(this.myHost, this.myPort), 10000);
        socket.setSoTimeout(this.mySoTimeout);
        socket.setKeepAlive(this.myKeepAlive);
        ourLog.trace("Connection established to {}:{}", (Object)this.myHost, (Object)this.myPort);
        this.myOutputStream = new BufferedOutputStream(socket.getOutputStream());
        this.myInputStream = new BufferedInputStream(socket.getInputStream());
        return socket;
    }

    private IReceivable<String> doSendAndReceiveInternal(ISendable<?> theMessageToSend, Socket socket) throws IOException, DecodeException, SignatureVerificationException, EncodeException {
        ourLog.trace("Entering doSendAndReceiveInternal()");
        Hl7OverHttpRequestEncoder enc = new Hl7OverHttpRequestEncoder();
        enc.setPath(this.myPath);
        enc.setHost(this.myHost);
        enc.setPort(this.myPort);
        enc.setCharset(this.myCharset);
        if (this.myAuthorizationCallback != null) {
            enc.setUsername(this.myAuthorizationCallback.provideUsername(this.myPath));
            enc.setPassword(this.myAuthorizationCallback.providePassword(this.myPath));
        }
        enc.setSigner(this.mySigner);
        enc.setDataProvider(theMessageToSend);
        ourLog.debug("Writing message to OutputStream");
        enc.encodeToOutputStream(this.myOutputStream);
        this.myOutputStream.flush();
        ourLog.debug("Reading response from OutputStream");
        RawReceivable response = null;
        long endTime = System.currentTimeMillis() + this.myResponseTimeout;
        do {
            try {
                Hl7OverHttpResponseDecoder d = new Hl7OverHttpResponseDecoder();
                d.setSigner(this.mySigner);
                d.setReadTimeout(this.myResponseTimeout);
                d.readHeadersAndContentsFromInputStreamAndDecode(this.myInputStream);
                response = new RawReceivable(d.getMessage());
                InetSocketAddress remoteSocketAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
                String hostAddress = remoteSocketAddress.getAddress() != null ? remoteSocketAddress.getAddress().getHostAddress() : null;
                response.addMetadata(MessageMetadataKeys.REMOTE_HOST_ADDRESS.name(), hostAddress);
                if (!d.isConnectionCloseHeaderPresent()) continue;
                ourLog.debug("Found Connection=close header, closing socket");
                this.closeSocket(socket);
            }
            catch (NoMessageReceivedException ex) {
                ourLog.debug("No message received yet");
            }
            catch (IOException e) {
                throw new DecodeException("Failed to read response from remote host", e);
            }
        } while (response == null && System.currentTimeMillis() < endTime);
        ourLog.trace("Leaving doSendAndReceiveInternal()");
        return response;
    }

    @Override
    public String getHost() {
        return this.myHost;
    }

    @Override
    public int getPort() {
        return this.myPort;
    }

    @Override
    public ISocketFactory getSocketFactory() {
        return this.mySocketFactory;
    }

    @Override
    public int getSoTimeout() {
        return this.mySoTimeout;
    }

    @Override
    public String getUriPath() {
        return this.myPath;
    }

    @Override
    public URL getUrl() {
        return this.myUrl;
    }

    @Override
    public String getUrlString() {
        return this.getUrl().toExternalForm();
    }

    @Override
    public boolean isKeepAlive() {
        return this.myKeepAlive;
    }

    boolean isSocketConnected(Socket socket) {
        return socket != null && !socket.isClosed() && !socket.isInputShutdown() && !socket.isOutputShutdown();
    }

    protected abstract Socket provideSocket() throws IOException;

    protected abstract void returnSocket(Socket var1);

    public synchronized IReceivable<String> sendAndReceive(ISendable<?> theMessageToSend) throws DecodeException, IOException, EncodeException {
        Socket socket = this.provideSocket();
        try {
            IReceivable<String> iReceivable = this.doSendAndReceiveInternal(theMessageToSend, socket);
            return iReceivable;
        }
        catch (DecodeException e) {
            ourLog.debug("Decode exception, going to close socket", (Throwable)e);
            this.closeSocket(socket);
            throw e;
        }
        catch (IOException e) {
            ourLog.debug("Caught IOException, going to close socket", (Throwable)e);
            this.closeSocket(socket);
            throw e;
        }
        catch (SignatureVerificationException e) {
            ourLog.debug("Failed to verify message signature", (Throwable)e);
            throw new DecodeException("Failed to verify message signature", e);
        }
        finally {
            this.returnSocket(socket);
        }
    }

    @Override
    public void setAuthorizationCallback(IAuthorizationClientCallback theAuthorizationCallback) {
        this.myAuthorizationCallback = theAuthorizationCallback;
    }

    @Override
    public void setCharset(Charset theCharset) {
        if (theCharset == null) {
            throw new NullPointerException("Charset can not be null");
        }
        this.myCharset = theCharset;
    }

    @Override
    public void setHost(String theHost) {
        this.myHost = theHost;
        if (StringUtils.isBlank(theHost)) {
            throw new IllegalArgumentException("Host can not be blank/null");
        }
    }

    @Override
    public void setKeepAlive(boolean theKeepAlive) {
        this.myKeepAlive = theKeepAlive;
    }

    @Override
    public void setPort(int thePort) {
        this.myPort = thePort;
        if (thePort <= 0) {
            throw new IllegalArgumentException("Port must be a positive integer");
        }
    }

    @Override
    public void setResponseTimeout(long theResponseTimeout) {
        if (theResponseTimeout <= 0L) {
            throw new IllegalArgumentException("Timeout can not be <= 0");
        }
        this.myResponseTimeout = theResponseTimeout;
    }

    @Override
    public void setSigner(ISigner theSigner) {
        this.mySigner = theSigner;
    }

    @Override
    public void setSocketFactory(ISocketFactory theSocketFactory) {
        if (theSocketFactory == null) {
            throw new NullPointerException("Socket factory can not be null");
        }
        this.mySocketFactory = theSocketFactory;
    }

    @Override
    public void setSoTimeout(int theSoTimeout) {
        this.mySoTimeout = theSoTimeout;
    }

    @Override
    public void setUriPath(String thePath) {
        this.myPath = thePath;
        if (StringUtils.isBlank(thePath)) {
            this.myPath = "/";
        }
        if (!thePath.startsWith("/")) {
            throw new IllegalArgumentException("Invalid URI (must start with '/'): " + thePath);
        }
        if (thePath.contains(" ")) {
            throw new IllegalArgumentException("Invalid URI: " + thePath);
        }
        try {
            new URI("http://localhost" + thePath);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid URI: " + thePath);
        }
    }

    @Override
    public void setUrl(URL theUrl) {
        this.setHost(AbstractRawClient.extractHost(theUrl));
        this.setPort(AbstractRawClient.extractPort(theUrl));
        this.setUriPath(AbstractRawClient.extractUri(theUrl));
        this.myUrl = theUrl;
        if (this.getSocketFactory() == DEFAULT_SOCKET_FACTORY && theUrl.getProtocol().toLowerCase().equals("https")) {
            this.setSocketFactory(new TlsSocketFactory());
        }
    }

    @Override
    public void setUrlString(String theString) {
        try {
            URL url = new URL(theString);
            this.setUrl(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("URL is not valid. Must be in the form http[s]:");
        }
        String protocol = this.myUrl.getProtocol().toLowerCase();
        if (!protocol.equals("http") && !protocol.equals("https")) {
            throw new IllegalStateException("URL protocol must be http or https");
        }
    }

    private static String extractHost(URL theUrl) {
        return theUrl.getHost();
    }

    private static int extractPort(URL theUrl) {
        return theUrl.getPort() != -1 ? theUrl.getPort() : theUrl.getDefaultPort();
    }

    private static String extractUri(URL theUrl) {
        return theUrl.getPath();
    }
}

