/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.hoh.relay.listener;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.app.SimpleServer;
import ca.uhn.hl7v2.hoh.relay.listener.IRelayListener;
import ca.uhn.hl7v2.hoh.util.Validate;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.llp.MinLowerLayerProtocol;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.GenericModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.protocol.ApplicationRouter;
import ca.uhn.hl7v2.protocol.ReceivingApplication;
import ca.uhn.hl7v2.util.SocketFactory;
import ca.uhn.hl7v2.util.StandardSocketFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class RelayMllpListener
implements InitializingBean,
DisposableBean,
IRelayListener,
BeanNameAware {
    private static final Logger ourLog = LoggerFactory.getLogger(RelayMllpListener.class);
    private final List<ReceivingApplication<? extends Message>> myApplications = new ArrayList<ReceivingApplication<? extends Message>>();
    private final List<ApplicationRouter.AppRoutingData> myAppRoutingData = new ArrayList<ApplicationRouter.AppRoutingData>();
    private String myBeanName;
    private int myPort;
    private SimpleServer myServer;
    private final AtomicInteger threadNum = new AtomicInteger(1);
    private DefaultHapiContext myContext;

    public void afterPropertiesSet() throws Exception {
        if (this.myPort <= 0) {
            throw new IllegalStateException("Port not set");
        }
        this.myContext = new DefaultHapiContext();
        StandardSocketFactory socketFactory = new StandardSocketFactory();
        socketFactory.setAcceptedSocketTimeout(2000);
        this.myContext.setSocketFactory((SocketFactory)socketFactory);
        this.myContext.setExecutorService(Executors.newCachedThreadPool(new MyThreadFactory()));
        this.myContext.setLowerLayerProtocol((LowerLayerProtocol)new MinLowerLayerProtocol(true));
        this.myContext.setModelClassFactory((ModelClassFactory)new GenericModelClassFactory());
        this.myServer = this.myContext.newServer(this.myPort, false);
        for (int i = 0; i < this.myAppRoutingData.size(); ++i) {
            this.myServer.registerApplication(this.myAppRoutingData.get(i), this.myApplications.get(i));
        }
        ourLog.info("Starting listener on port {}", (Object)this.myPort);
        this.myServer.startAndWait();
        ourLog.info("Listener on port {} has started, and is ready for processing", (Object)this.myPort);
        if (this.myServer.getServiceExitedWithException() != null) {
            Throwable ex = this.myServer.getServiceExitedWithException();
            ourLog.error("Server failed to start", ex);
            if (ex instanceof Exception) {
                throw (Exception)ex;
            }
            throw new Error(ex);
        }
    }

    public void destroy() throws Exception {
        ourLog.info("Stopping listener on port {}", (Object)this.myPort);
        this.myServer.stopAndWait();
        ourLog.info("Listener on port {} has stopped", (Object)this.myPort);
        ourLog.info("Closing HAPI Context Object");
        this.myContext.close();
        ourLog.info("Done closing HAPI Context object");
    }

    public String getBeanName() {
        return this.myBeanName;
    }

    @Override
    public void registerApplication(ApplicationRouter.AppRoutingData theAppRouting, ReceivingApplication<? extends Message> theReceivingApplication) {
        Validate.notNull(theAppRouting, "appRouting");
        Validate.notNull(theReceivingApplication, "receivingApplication");
        if (this.myServer != null) {
            this.myServer.registerApplication(theAppRouting, theReceivingApplication);
        } else {
            this.myAppRoutingData.add(theAppRouting);
            this.myApplications.add(theReceivingApplication);
        }
    }

    public void setBeanName(String theBeanName) {
        this.myBeanName = theBeanName;
    }

    public void setPort(int thePort) {
        this.myPort = thePort;
    }

    private class MyThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group = Thread.currentThread().getThreadGroup();

        private MyThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable theR) {
            String name = "hoh-port-" + RelayMllpListener.this.myPort + "-worker-" + RelayMllpListener.this.threadNum.getAndIncrement();
            Thread t = new Thread(this.group, theR, name, 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

