/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.CSU_C11_STUDY_OBSERVATION;
import ca.uhn.hl7v2.model.v23.group.CSU_C11_STUDY_PHARM;
import ca.uhn.hl7v2.model.v23.segment.CSS;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSU_C11_STUDY_SCHEDULE
extends AbstractGroup {
    public CSU_C11_STUDY_SCHEDULE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CSS.class, false, false);
            this.add(CSU_C11_STUDY_OBSERVATION.class, false, true);
            this.add(CSU_C11_STUDY_PHARM.class, true, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating CSU_C11_STUDY_SCHEDULE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public CSS getCSS() {
        CSS ret = null;
        try {
            ret = (CSS)this.get("CSS");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CSU_C11_STUDY_OBSERVATION getSTUDY_OBSERVATION() {
        CSU_C11_STUDY_OBSERVATION ret = null;
        try {
            ret = (CSU_C11_STUDY_OBSERVATION)this.get("STUDY_OBSERVATION");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CSU_C11_STUDY_OBSERVATION getSTUDY_OBSERVATION(int rep) {
        CSU_C11_STUDY_OBSERVATION ret = null;
        try {
            ret = (CSU_C11_STUDY_OBSERVATION)this.get("STUDY_OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSTUDY_OBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("STUDY_OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<CSU_C11_STUDY_OBSERVATION> getSTUDY_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("STUDY_OBSERVATION", CSU_C11_STUDY_OBSERVATION.class);
    }

    public void insertSTUDY_OBSERVATION(CSU_C11_STUDY_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("STUDY_OBSERVATION", (Structure)structure, rep);
    }

    public CSU_C11_STUDY_OBSERVATION insertSTUDY_OBSERVATION(int rep) throws HL7Exception {
        return (CSU_C11_STUDY_OBSERVATION)super.insertRepetition("STUDY_OBSERVATION", rep);
    }

    public CSU_C11_STUDY_OBSERVATION removeSTUDY_OBSERVATION(int rep) throws HL7Exception {
        return (CSU_C11_STUDY_OBSERVATION)super.removeRepetition("STUDY_OBSERVATION", rep);
    }

    public CSU_C11_STUDY_PHARM getSTUDY_PHARM() {
        CSU_C11_STUDY_PHARM ret = null;
        try {
            ret = (CSU_C11_STUDY_PHARM)this.get("STUDY_PHARM");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CSU_C11_STUDY_PHARM getSTUDY_PHARM(int rep) {
        CSU_C11_STUDY_PHARM ret = null;
        try {
            ret = (CSU_C11_STUDY_PHARM)this.get("STUDY_PHARM", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSTUDY_PHARMReps() {
        int reps = -1;
        try {
            reps = this.getAll("STUDY_PHARM").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<CSU_C11_STUDY_PHARM> getSTUDY_PHARMAll() throws HL7Exception {
        return this.getAllAsList("STUDY_PHARM", CSU_C11_STUDY_PHARM.class);
    }

    public void insertSTUDY_PHARM(CSU_C11_STUDY_PHARM structure, int rep) throws HL7Exception {
        super.insertRepetition("STUDY_PHARM", (Structure)structure, rep);
    }

    public CSU_C11_STUDY_PHARM insertSTUDY_PHARM(int rep) throws HL7Exception {
        return (CSU_C11_STUDY_PHARM)super.insertRepetition("STUDY_PHARM", rep);
    }

    public CSU_C11_STUDY_PHARM removeSTUDY_PHARM(int rep) throws HL7Exception {
        return (CSU_C11_STUDY_PHARM)super.removeRepetition("STUDY_PHARM", rep);
    }
}

