/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.segment.LCC;
import ca.uhn.hl7v2.model.v23.segment.LCH;
import ca.uhn.hl7v2.model.v23.segment.LDP;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFN_M05_MF_LOC_DEPT
extends AbstractGroup {
    public MFN_M05_MF_LOC_DEPT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(LDP.class, true, false);
            this.add(LCH.class, false, true);
            this.add(LCC.class, false, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating MFN_M05_MF_LOC_DEPT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public LDP getLDP() {
        LDP ret = null;
        try {
            ret = (LDP)this.get("LDP");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LCH getLCH() {
        LCH ret = null;
        try {
            ret = (LCH)this.get("LCH");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LCH getLCH(int rep) {
        LCH ret = null;
        try {
            ret = (LCH)this.get("LCH", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getLCHReps() {
        int reps = -1;
        try {
            reps = this.getAll("LCH").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<LCH> getLCHAll() throws HL7Exception {
        return this.getAllAsList("LCH", LCH.class);
    }

    public void insertLCH(LCH structure, int rep) throws HL7Exception {
        super.insertRepetition("LCH", (Structure)structure, rep);
    }

    public LCH insertLCH(int rep) throws HL7Exception {
        return (LCH)super.insertRepetition("LCH", rep);
    }

    public LCH removeLCH(int rep) throws HL7Exception {
        return (LCH)super.removeRepetition("LCH", rep);
    }

    public LCC getLCC() {
        LCC ret = null;
        try {
            ret = (LCC)this.get("LCC");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public LCC getLCC(int rep) {
        LCC ret = null;
        try {
            ret = (LCC)this.get("LCC", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getLCCReps() {
        int reps = -1;
        try {
            reps = this.getAll("LCC").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<LCC> getLCCAll() throws HL7Exception {
        return this.getAllAsList("LCC", LCC.class);
    }

    public void insertLCC(LCC structure, int rep) throws HL7Exception {
        super.insertRepetition("LCC", (Structure)structure, rep);
    }

    public LCC insertLCC(int rep) throws HL7Exception {
        return (LCC)super.insertRepetition("LCC", rep);
    }

    public LCC removeLCC(int rep) throws HL7Exception {
        return (LCC)super.removeRepetition("LCC", rep);
    }
}

