/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v23.group.VXU_V04_INSURANCE;
import ca.uhn.hl7v2.model.v23.group.VXU_V04_ORDER;
import ca.uhn.hl7v2.model.v23.group.VXU_V04_PATIENT;
import ca.uhn.hl7v2.model.v23.segment.MSH;
import ca.uhn.hl7v2.model.v23.segment.NK1;
import ca.uhn.hl7v2.model.v23.segment.PD1;
import ca.uhn.hl7v2.model.v23.segment.PID;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VXU_V04
extends AbstractMessage {
    public VXU_V04() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public VXU_V04(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(PID.class, true, false);
            this.add(PD1.class, false, false);
            this.add(NK1.class, false, true);
            this.add(VXU_V04_PATIENT.class, false, false);
            this.add(VXU_V04_INSURANCE.class, false, true);
            this.add(VXU_V04_ORDER.class, false, true);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error creating VXU_V04 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public MSH getMSH() {
        MSH ret = null;
        try {
            ret = (MSH)this.get("MSH");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PID getPID() {
        PID ret = null;
        try {
            ret = (PID)this.get("PID");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public PD1 getPD1() {
        PD1 ret = null;
        try {
            ret = (PD1)this.get("PD1");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NK1 getNK1() {
        NK1 ret = null;
        try {
            ret = (NK1)this.get("NK1");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public NK1 getNK1(int rep) {
        NK1 ret = null;
        try {
            ret = (NK1)this.get("NK1", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getNK1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("NK1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", (Structure)structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public VXU_V04_PATIENT getPATIENT() {
        VXU_V04_PATIENT ret = null;
        try {
            ret = (VXU_V04_PATIENT)this.get("PATIENT");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VXU_V04_INSURANCE getINSURANCE() {
        VXU_V04_INSURANCE ret = null;
        try {
            ret = (VXU_V04_INSURANCE)this.get("INSURANCE");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VXU_V04_INSURANCE getINSURANCE(int rep) {
        VXU_V04_INSURANCE ret = null;
        try {
            ret = (VXU_V04_INSURANCE)this.get("INSURANCE", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getINSURANCEReps() {
        int reps = -1;
        try {
            reps = this.getAll("INSURANCE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<VXU_V04_INSURANCE> getINSURANCEAll() throws HL7Exception {
        return this.getAllAsList("INSURANCE", VXU_V04_INSURANCE.class);
    }

    public void insertINSURANCE(VXU_V04_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("INSURANCE", (Structure)structure, rep);
    }

    public VXU_V04_INSURANCE insertINSURANCE(int rep) throws HL7Exception {
        return (VXU_V04_INSURANCE)super.insertRepetition("INSURANCE", rep);
    }

    public VXU_V04_INSURANCE removeINSURANCE(int rep) throws HL7Exception {
        return (VXU_V04_INSURANCE)super.removeRepetition("INSURANCE", rep);
    }

    public VXU_V04_ORDER getORDER() {
        VXU_V04_ORDER ret = null;
        try {
            ret = (VXU_V04_ORDER)this.get("ORDER");
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public VXU_V04_ORDER getORDER(int rep) {
        VXU_V04_ORDER ret = null;
        try {
            ret = (VXU_V04_ORDER)this.get("ORDER", rep);
        }
        catch (HL7Exception e) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public List<VXU_V04_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", VXU_V04_ORDER.class);
    }

    public void insertORDER(VXU_V04_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public VXU_V04_ORDER insertORDER(int rep) throws HL7Exception {
        return (VXU_V04_ORDER)super.insertRepetition("ORDER", rep);
    }

    public VXU_V04_ORDER removeORDER(int rep) throws HL7Exception {
        return (VXU_V04_ORDER)super.removeRepetition("ORDER", rep);
    }
}

