/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v24.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 OSP (occurence span) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>occurrence span code (CE)
 * <li>occurrence span start date (DT)
 * <li>occurrence span stop date (DT)
 * </ul>
 */
public class OSP extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new OSP type
     */
    public OSP(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[3];    
        data[0] = new CE(getMessage());
        data[1] = new DT(getMessage());
        data[2] = new DT(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns occurrence span code (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getOccurrenceSpanCode() {
       CE ret = null;
       try {
          ret = (CE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns occurrence span code (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getOsp1_OccurrenceSpanCode() {
       CE ret = null;
       try {
          ret = (CE)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns occurrence span start date (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DT getOccurrenceSpanStartDate() {
       DT ret = null;
       try {
          ret = (DT)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns occurrence span start date (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DT getOsp2_OccurrenceSpanStartDate() {
       DT ret = null;
       try {
          ret = (DT)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns occurrence span stop date (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DT getOccurrenceSpanStopDate() {
       DT ret = null;
       try {
          ret = (DT)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns occurrence span stop date (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DT getOsp3_OccurrenceSpanStopDate() {
       DT ret = null;
       try {
          ret = (DT)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

