/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v24.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 SN (structured numeric) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>comparator (ST)
 * <li>num1 (NM)
 * <li>separator/suffix (ST)
 * <li>num2 (NM)
 * </ul>
 */
public class SN extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new SN type
     */
    public SN(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[4];    
        data[0] = new ST(getMessage());
        data[1] = new NM(getMessage());
        data[2] = new ST(getMessage());
        data[3] = new NM(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns comparator (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getComparator() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns comparator (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getSn1_Comparator() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns num1 (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getNum1() {
       NM ret = null;
       try {
          ret = (NM)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns num1 (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getSn2_Num1() {
       NM ret = null;
       try {
          ret = (NM)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns separator/suffix (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getSeparatorSuffix() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns separator/suffix (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getSn3_SeparatorSuffix() {
       ST ret = null;
       try {
          ret = (ST)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns num2 (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getNum2() {
       NM ret = null;
       try {
          ret = (NM)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns num2 (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public NM getSn4_Num2() {
       NM ret = null;
       try {
          ret = (NM)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

