/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v24.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 SPD (Specialty) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>specialty name (ST)
 * <li>governing board (ST)
 * <li>eligible or certified (ID)
 * <li>date of certification (DT)
 * </ul>
 */
public class SPD extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new SPD type
     */
    public SPD(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[4];    
        data[0] = new ST(getMessage());
        data[1] = new ST(getMessage());
        data[2] = new ID(getMessage(), 0);
        data[3] = new DT(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns specialty name (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getSpecialtyName() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns specialty name (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getSpd1_SpecialtyName() {
       ST ret = null;
       try {
          ret = (ST)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns governing board (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getGoverningBoard() {
       ST ret = null;
       try {
          ret = (ST)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns governing board (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ST getSpd2_GoverningBoard() {
       ST ret = null;
       try {
          ret = (ST)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns eligible or certified (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getEligibleOrCertified() {
       ID ret = null;
       try {
          ret = (ID)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns eligible or certified (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getSpd3_EligibleOrCertified() {
       ID ret = null;
       try {
          ret = (ID)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns date of certification (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DT getDateOfCertification() {
       DT ret = null;
       try {
          ret = (DT)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns date of certification (component #4).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public DT getSpd4_DateOfCertification() {
       DT ret = null;
       try {
          ret = (DT)getComponent(3);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

