/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.model.v24.group.*;
import ca.uhn.hl7v2.model.v24.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a EAC_U07 message structure (see chapter 13). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (Message Header) <b> </b></li>
                 * <li>2: EQU (Equipment Detail) <b> </b></li>
                 * <li>3: ECD (Equipment Command) <b> repeating</b></li>
                 * <li>4: SAC (Specimen and container detail) <b>optional </b></li>
                 * <li>5: CNS (Clear Notification) <b>optional </b></li>
                 * <li>6: ROL (Role) <b>optional </b></li>
 * </ul>
 */
public class EAC_U07 extends AbstractMessage  {

    /** 
     * Creates a new EAC_U07 message with custom ModelClassFactory.
     */
    public EAC_U07(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    /**
     * Creates a new EAC_U07 message with DefaultModelClassFactory. 
     */ 
    public EAC_U07() { 
       super(new DefaultModelClassFactory());
       init(new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(EQU.class, true, false);
                          this.add(ECD.class, true, true);
                          this.add(SAC.class, false, false);
                          this.add(CNS.class, false, false);
                          this.add(ROL.class, false, false);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating EAC_U07 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.4"
     */
    public String getVersion() {
       return "2.4";
    }



    /**
     * Returns
     * MSH (Message Header) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * EQU (Equipment Detail) - creates it if necessary
     */
    public EQU getEQU() { 
       EQU ret = null;
       try {
          ret = (EQU)this.get("EQU");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * ECD (Equipment Command) - creates it if necessary
     */
    public ECD getECD() { 
       ECD ret = null;
       try {
          ret = (ECD)this.get("ECD");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * ECD (Equipment Command) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public ECD getECD(int rep) { 
       ECD ret = null;
       try {
          ret = (ECD)this.get("ECD", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of ECD 
     */ 
    public int getECDReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("ECD").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of ECD (Equipment Command)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertECD(ECD structure, int rep) throws HL7Exception { 
       super.insertRepetition( "ECD", structure, rep);
    }


    /**
     * Inserts a specific repetition of ECD (Equipment Command)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public ECD insertECD(int rep) throws HL7Exception { 
       return (ECD)super.insertRepetition("ECD", rep);
    }


    /**
     * Removes a specific repetition of ECD (Equipment Command)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public ECD removeECD(int rep) throws HL7Exception { 
       return (ECD)super.removeRepetition("ECD", rep);
    }



    /**
     * Returns
     * SAC (Specimen and container detail) - creates it if necessary
     */
    public SAC getSAC() { 
       SAC ret = null;
       try {
          ret = (SAC)this.get("SAC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * CNS (Clear Notification) - creates it if necessary
     */
    public CNS getCNS() { 
       CNS ret = null;
       try {
          ret = (CNS)this.get("CNS");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * ROL (Role) - creates it if necessary
     */
    public ROL getROL() { 
       ROL ret = null;
       try {
          ret = (ROL)this.get("ROL");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




}

