/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.model.v24.group.*;
import ca.uhn.hl7v2.model.v24.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a MFN_M01 message structure (see chapter 8). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (Message Header) <b> </b></li>
                 * <li>2: MFI (Master File Identification) <b> </b></li>
                 * <li>3: MFN_M01_MF (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class MFN_M01 extends AbstractMessage  {

    /** 
     * Creates a new MFN_M01 message with custom ModelClassFactory.
     */
    public MFN_M01(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    /**
     * Creates a new MFN_M01 message with DefaultModelClassFactory. 
     */ 
    public MFN_M01() { 
       super(new DefaultModelClassFactory());
       init(new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(MFI.class, true, false);
                          this.add(MFN_M01_MF.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating MFN_M01 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.4"
     */
    public String getVersion() {
       return "2.4";
    }



    /**
     * Returns
     * MSH (Message Header) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * MFI (Master File Identification) - creates it if necessary
     */
    public MFI getMFI() { 
       MFI ret = null;
       try {
          ret = (MFI)this.get("MFI");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * MF (a Group object) - creates it if necessary
     */
    public MFN_M01_MF getMF() { 
       MFN_M01_MF ret = null;
       try {
          ret = (MFN_M01_MF)this.get("MF");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * MF (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public MFN_M01_MF getMF(int rep) { 
       MFN_M01_MF ret = null;
       try {
          ret = (MFN_M01_MF)this.get("MF", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of MF 
     */ 
    public int getMFReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("MF").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of MF (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertMF(MFN_M01_MF structure, int rep) throws HL7Exception { 
       super.insertRepetition( "MF", structure, rep);
    }


    /**
     * Inserts a specific repetition of MF (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public MFN_M01_MF insertMF(int rep) throws HL7Exception { 
       return (MFN_M01_MF)super.insertRepetition("MF", rep);
    }


    /**
     * Removes a specific repetition of MF (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public MFN_M01_MF removeMF(int rep) throws HL7Exception { 
       return (MFN_M01_MF)super.removeRepetition("MF", rep);
    }



}

