/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.model.v24.group.*;
import ca.uhn.hl7v2.model.v24.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a NMR_N01 message structure (see chapter 14). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (Message Header) <b> </b></li>
                 * <li>2: MSA (Message Acknowledgment) <b> </b></li>
                 * <li>3: ERR (Error) <b>optional </b></li>
                 * <li>4: QRD (Original-Style Query Definition) <b>optional </b></li>
                 * <li>5: NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class NMR_N01 extends AbstractMessage  {

    /** 
     * Creates a new NMR_N01 message with custom ModelClassFactory.
     */
    public NMR_N01(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    /**
     * Creates a new NMR_N01 message with DefaultModelClassFactory. 
     */ 
    public NMR_N01() { 
       super(new DefaultModelClassFactory());
       init(new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(MSA.class, true, false);
                          this.add(ERR.class, false, false);
                          this.add(QRD.class, false, false);
                          this.add(NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating NMR_N01 - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.4"
     */
    public String getVersion() {
       return "2.4";
    }



    /**
     * Returns
     * MSH (Message Header) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * MSA (Message Acknowledgment) - creates it if necessary
     */
    public MSA getMSA() { 
       MSA ret = null;
       try {
          ret = (MSA)this.get("MSA");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * ERR (Error) - creates it if necessary
     */
    public ERR getERR() { 
       ERR ret = null;
       try {
          ret = (ERR)this.get("ERR");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * QRD (Original-Style Query Definition) - creates it if necessary
     */
    public QRD getQRD() { 
       QRD ret = null;
       try {
          ret = (QRD)this.get("QRD");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * CLOCK_AND_STATS_WITH_NOTES_ALT (a Group object) - creates it if necessary
     */
    public NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT getCLOCK_AND_STATS_WITH_NOTES_ALT() { 
       NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT ret = null;
       try {
          ret = (NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT)this.get("CLOCK_AND_STATS_WITH_NOTES_ALT");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * CLOCK_AND_STATS_WITH_NOTES_ALT (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT getCLOCK_AND_STATS_WITH_NOTES_ALT(int rep) { 
       NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT ret = null;
       try {
          ret = (NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT)this.get("CLOCK_AND_STATS_WITH_NOTES_ALT", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of CLOCK_AND_STATS_WITH_NOTES_ALT 
     */ 
    public int getCLOCK_AND_STATS_WITH_NOTES_ALTReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("CLOCK_AND_STATS_WITH_NOTES_ALT").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of CLOCK_AND_STATS_WITH_NOTES_ALT (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertCLOCK_AND_STATS_WITH_NOTES_ALT(NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT structure, int rep) throws HL7Exception { 
       super.insertRepetition( "CLOCK_AND_STATS_WITH_NOTES_ALT", structure, rep);
    }


    /**
     * Inserts a specific repetition of CLOCK_AND_STATS_WITH_NOTES_ALT (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT insertCLOCK_AND_STATS_WITH_NOTES_ALT(int rep) throws HL7Exception { 
       return (NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT)super.insertRepetition("CLOCK_AND_STATS_WITH_NOTES_ALT", rep);
    }


    /**
     * Removes a specific repetition of CLOCK_AND_STATS_WITH_NOTES_ALT (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT removeCLOCK_AND_STATS_WITH_NOTES_ALT(int rep) throws HL7Exception { 
       return (NMR_N01_CLOCK_AND_STATS_WITH_NOTES_ALT)super.removeRepetition("CLOCK_AND_STATS_WITH_NOTES_ALT", rep);
    }



}

