/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.model.v24.group.*;
import ca.uhn.hl7v2.model.v24.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;

/**
 * <p>Represents a PPP_PCB message structure (see chapter 12). This structure contains the 
 * following elements: </p>
 * <ul>
                 * <li>1: MSH (Message Header) <b> </b></li>
                 * <li>2: PID (Patient identification) <b> </b></li>
                 * <li>3: PPP_PCB_PATIENT_VISIT (a Group object) <b>optional </b></li>
                 * <li>4: PPP_PCB_PATHWAY (a Group object) <b> repeating</b></li>
 * </ul>
 */
public class PPP_PCB extends AbstractMessage  {

    /** 
     * Creates a new PPP_PCB message with custom ModelClassFactory.
     */
    public PPP_PCB(ModelClassFactory factory) {
       super(factory);
       init(factory);
    }

    /**
     * Creates a new PPP_PCB message with DefaultModelClassFactory. 
     */ 
    public PPP_PCB() { 
       super(new DefaultModelClassFactory());
       init(new DefaultModelClassFactory());
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(MSH.class, true, false);
                          this.add(PID.class, true, false);
                          this.add(PPP_PCB_PATIENT_VISIT.class, false, false);
                          this.add(PPP_PCB_PATHWAY.class, true, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PPP_PCB - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.4"
     */
    public String getVersion() {
       return "2.4";
    }



    /**
     * Returns
     * MSH (Message Header) - creates it if necessary
     */
    public MSH getMSH() { 
       MSH ret = null;
       try {
          ret = (MSH)this.get("MSH");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * PID (Patient identification) - creates it if necessary
     */
    public PID getPID() { 
       PID ret = null;
       try {
          ret = (PID)this.get("PID");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * PATIENT_VISIT (a Group object) - creates it if necessary
     */
    public PPP_PCB_PATIENT_VISIT getPATIENT_VISIT() { 
       PPP_PCB_PATIENT_VISIT ret = null;
       try {
          ret = (PPP_PCB_PATIENT_VISIT)this.get("PATIENT_VISIT");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * PATHWAY (a Group object) - creates it if necessary
     */
    public PPP_PCB_PATHWAY getPATHWAY() { 
       PPP_PCB_PATHWAY ret = null;
       try {
          ret = (PPP_PCB_PATHWAY)this.get("PATHWAY");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * PATHWAY (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public PPP_PCB_PATHWAY getPATHWAY(int rep) { 
       PPP_PCB_PATHWAY ret = null;
       try {
          ret = (PPP_PCB_PATHWAY)this.get("PATHWAY", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of PATHWAY 
     */ 
    public int getPATHWAYReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("PATHWAY").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of PATHWAY (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public void insertPATHWAY(PPP_PCB_PATHWAY structure, int rep) throws HL7Exception { 
       super.insertRepetition( "PATHWAY", structure, rep);
    }


    /**
     * Inserts a specific repetition of PATHWAY (a Group object)
     * @see AbstractGroup\#insertRepetition(Structure, int) 
     */
    public PPP_PCB_PATHWAY insertPATHWAY(int rep) throws HL7Exception { 
       return (PPP_PCB_PATHWAY)super.insertRepetition("PATHWAY", rep);
    }


    /**
     * Removes a specific repetition of PATHWAY (a Group object)
     * @see AbstractGroup\#removeRepetition(String, int) 
     */
    public PPP_PCB_PATHWAY removePATHWAY(int rep) throws HL7Exception { 
       return (PPP_PCB_PATHWAY)super.removeRepetition("PATHWAY", rep);
    }



}

