/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v24.segment;

// import ca.uhn.hl7v2.model.v24.group.*;
import ca.uhn.hl7v2.model.v24.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 NDS message segment (Notification Detail). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>NDS-1: Notification Reference Number (NM) <b> </b>
     * <li>NDS-2: Notification Date/Time (TS) <b> </b>
     * <li>NDS-3: Notification Alert Severity (CE) <b> </b>
     * <li>NDS-4: Notification Code (CE) <b> </b>
 * </ul>
 */
public class NDS extends AbstractSegment {

    /** 
     * Creates a new NDS segment
     */
    public NDS(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(NM.class, true, 1, 20, new Object[]{ getMessage(), new Integer(0) }, "Notification Reference Number");
                                  this.add(TS.class, true, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Notification Date/Time");
                                  this.add(CE.class, true, 1, 250, new Object[]{ getMessage(), new Integer(367) }, "Notification Alert Severity");
                                  this.add(CE.class, true, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Notification Code");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating NDS - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * NDS-1: "Notification Reference Number" - creates it if necessary
     */
    public NM getNotificationReferenceNumber() { 
        NM ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NDS-1: "Notification Reference Number" - creates it if necessary
     */
    public NM getNds1_NotificationReferenceNumber() { 
        NM ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NDS-2: "Notification Date/Time" - creates it if necessary
     */
    public TS getNotificationDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NDS-2: "Notification Date/Time" - creates it if necessary
     */
    public TS getNds2_NotificationDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NDS-3: "Notification Alert Severity" - creates it if necessary
     */
    public CE getNotificationAlertSeverity() { 
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NDS-3: "Notification Alert Severity" - creates it if necessary
     */
    public CE getNds3_NotificationAlertSeverity() { 
        CE ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * NDS-4: "Notification Code" - creates it if necessary
     */
    public CE getNotificationCode() { 
        CE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * NDS-4: "Notification Code" - creates it if necessary
     */
    public CE getNds4_NotificationCode() { 
        CE ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new NM(getMessage());
          case 1: return new TS(getMessage());
          case 2: return new CE(getMessage());
          case 3: return new CE(getMessage());
          default: return null;
       }
   }


}

