/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v24.segment;

// import ca.uhn.hl7v2.model.v24.group.*;
import ca.uhn.hl7v2.model.v24.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 PRA message segment (Practitioner Detail). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>PRA-1: Primary Key Value - PRA (CE) <b>optional </b>
     * <li>PRA-2: Practitioner Group (CE) <b>optional repeating</b>
     * <li>PRA-3: Practitioner Category (IS) <b>optional repeating</b>
     * <li>PRA-4: Provider Billing (ID) <b>optional </b>
     * <li>PRA-5: Specialty (SPD) <b>optional repeating</b>
     * <li>PRA-6: Practitioner ID Numbers (PLN) <b>optional repeating</b>
     * <li>PRA-7: Privileges (PIP) <b>optional repeating</b>
     * <li>PRA-8: Date Entered Practice (DT) <b>optional </b>
     * <li>PRA-9: Institution (CE) <b>optional </b>
     * <li>PRA-10: Date Left Practice (DT) <b>optional </b>
     * <li>PRA-11: Government Reimbursement Billing Eligibility (CE) <b>optional repeating</b>
     * <li>PRA-12: Set ID - PRA (SI) <b>optional </b>
 * </ul>
 */
public class PRA extends AbstractSegment {

    /** 
     * Creates a new PRA segment
     */
    public PRA(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(9999) }, "Primary Key Value - PRA");
                                  this.add(CE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(358) }, "Practitioner Group");
                                  this.add(IS.class, false, 0, 3, new Object[]{ getMessage() }, "Practitioner Category");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Provider Billing");
                                  this.add(SPD.class, false, 0, 100, new Object[]{ getMessage(), new Integer(337) }, "Specialty");
                                  this.add(PLN.class, false, 0, 100, new Object[]{ getMessage(), new Integer(338) }, "Practitioner ID Numbers");
                                  this.add(PIP.class, false, 0, 200, new Object[]{ getMessage(), new Integer(0) }, "Privileges");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Date Entered Practice");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Institution");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Date Left Practice");
                                  this.add(CE.class, false, 0, 250, new Object[]{ getMessage(), new Integer(401) }, "Government Reimbursement Billing Eligibility");
                                  this.add(SI.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "Set ID - PRA");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating PRA - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * PRA-1: "Primary Key Value - PRA" - creates it if necessary
     */
    public CE getPrimaryKeyValuePRA() { 
        CE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRA-1: "Primary Key Value - PRA" - creates it if necessary
     */
    public CE getPra1_PrimaryKeyValuePRA() { 
        CE ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Practitioner Group (PRA-2).
     */
    public CE[] getPractitionerGroup() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(2);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRA-2: "Practitioner Group" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getPractitionerGroup(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRA-2: "Practitioner Group" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getPra2_PractitionerGroup(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PRA-2: "Practitioner Group" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertPractitionerGroup(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(2, rep);
    }



    /**
     * Inserts a repetition of
     * PRA-2: "Practitioner Group" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertPra2_PractitionerGroup(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * PRA-2: "Practitioner Group" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removePractitionerGroup(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * PRA-2: "Practitioner Group" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removePra2_PractitionerGroup(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(2, rep);
    }



    /**
     * Returns all repetitions of Practitioner Category (PRA-3).
     */
    public IS[] getPractitionerCategory() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(3);  
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (IS)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRA-3: "Practitioner Category" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getPractitionerCategory(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRA-3: "Practitioner Category" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getPra3_PractitionerCategory(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PRA-3: "Practitioner Category" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertPractitionerCategory(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(3, rep);
    }



    /**
     * Inserts a repetition of
     * PRA-3: "Practitioner Category" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertPra3_PractitionerCategory(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * PRA-3: "Practitioner Category" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removePractitionerCategory(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * PRA-3: "Practitioner Category" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removePra3_PractitionerCategory(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(3, rep);
    }




    /**
     * Returns
     * PRA-4: "Provider Billing" - creates it if necessary
     */
    public ID getProviderBilling() { 
        ID ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRA-4: "Provider Billing" - creates it if necessary
     */
    public ID getPra4_ProviderBilling() { 
        ID ret = null;
        try {
            Type t = this.getField(4, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Specialty (PRA-5).
     */
    public SPD[] getSpecialty() {
        SPD[] ret = null;
        try {
            Type[] t = this.getField(5);  
            ret = new SPD[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (SPD)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRA-5: "Specialty" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public SPD getSpecialty(int rep) { 
        SPD ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (SPD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRA-5: "Specialty" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public SPD getPra5_Specialty(int rep) { 
        SPD ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (SPD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PRA-5: "Specialty" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SPD insertSpecialty(int rep) throws HL7Exception { 
        return (SPD) super.insertRepetition(5, rep);
    }



    /**
     * Inserts a repetition of
     * PRA-5: "Specialty" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SPD insertPra5_Specialty(int rep) throws HL7Exception { 
        return (SPD) super.insertRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * PRA-5: "Specialty" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SPD removeSpecialty(int rep) throws HL7Exception { 
        return (SPD) super.removeRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * PRA-5: "Specialty" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public SPD removePra5_Specialty(int rep) throws HL7Exception { 
        return (SPD) super.removeRepetition(5, rep);
    }



    /**
     * Returns all repetitions of Practitioner ID Numbers (PRA-6).
     */
    public PLN[] getPractitionerIDNumbers() {
        PLN[] ret = null;
        try {
            Type[] t = this.getField(6);  
            ret = new PLN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (PLN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRA-6: "Practitioner ID Numbers" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public PLN getPractitionerIDNumbers(int rep) { 
        PLN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (PLN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRA-6: "Practitioner ID Numbers" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public PLN getPra6_PractitionerIDNumbers(int rep) { 
        PLN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (PLN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PRA-6: "Practitioner ID Numbers" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public PLN insertPractitionerIDNumbers(int rep) throws HL7Exception { 
        return (PLN) super.insertRepetition(6, rep);
    }



    /**
     * Inserts a repetition of
     * PRA-6: "Practitioner ID Numbers" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public PLN insertPra6_PractitionerIDNumbers(int rep) throws HL7Exception { 
        return (PLN) super.insertRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * PRA-6: "Practitioner ID Numbers" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public PLN removePractitionerIDNumbers(int rep) throws HL7Exception { 
        return (PLN) super.removeRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * PRA-6: "Practitioner ID Numbers" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public PLN removePra6_PractitionerIDNumbers(int rep) throws HL7Exception { 
        return (PLN) super.removeRepetition(6, rep);
    }



    /**
     * Returns all repetitions of Privileges (PRA-7).
     */
    public PIP[] getPrivileges() {
        PIP[] ret = null;
        try {
            Type[] t = this.getField(7);  
            ret = new PIP[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (PIP)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRA-7: "Privileges" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public PIP getPrivileges(int rep) { 
        PIP ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (PIP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRA-7: "Privileges" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public PIP getPra7_Privileges(int rep) { 
        PIP ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (PIP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PRA-7: "Privileges" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public PIP insertPrivileges(int rep) throws HL7Exception { 
        return (PIP) super.insertRepetition(7, rep);
    }



    /**
     * Inserts a repetition of
     * PRA-7: "Privileges" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public PIP insertPra7_Privileges(int rep) throws HL7Exception { 
        return (PIP) super.insertRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * PRA-7: "Privileges" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public PIP removePrivileges(int rep) throws HL7Exception { 
        return (PIP) super.removeRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * PRA-7: "Privileges" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public PIP removePra7_Privileges(int rep) throws HL7Exception { 
        return (PIP) super.removeRepetition(7, rep);
    }




    /**
     * Returns
     * PRA-8: "Date Entered Practice" - creates it if necessary
     */
    public DT getDateEnteredPractice() { 
        DT ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRA-8: "Date Entered Practice" - creates it if necessary
     */
    public DT getPra8_DateEnteredPractice() { 
        DT ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRA-9: "Institution" - creates it if necessary
     */
    public CE getInstitution() { 
        CE ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRA-9: "Institution" - creates it if necessary
     */
    public CE getPra9_Institution() { 
        CE ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * PRA-10: "Date Left Practice" - creates it if necessary
     */
    public DT getDateLeftPractice() { 
        DT ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRA-10: "Date Left Practice" - creates it if necessary
     */
    public DT getPra10_DateLeftPractice() { 
        DT ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Government Reimbursement Billing Eligibility (PRA-11).
     */
    public CE[] getGovernmentReimbursementBillingEligibility() {
        CE[] ret = null;
        try {
            Type[] t = this.getField(11);  
            ret = new CE[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CE)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRA-11: "Government Reimbursement Billing Eligibility" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getGovernmentReimbursementBillingEligibility(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * PRA-11: "Government Reimbursement Billing Eligibility" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CE getPra11_GovernmentReimbursementBillingEligibility(int rep) { 
        CE ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * PRA-11: "Government Reimbursement Billing Eligibility" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertGovernmentReimbursementBillingEligibility(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(11, rep);
    }



    /**
     * Inserts a repetition of
     * PRA-11: "Government Reimbursement Billing Eligibility" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE insertPra11_GovernmentReimbursementBillingEligibility(int rep) throws HL7Exception { 
        return (CE) super.insertRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * PRA-11: "Government Reimbursement Billing Eligibility" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removeGovernmentReimbursementBillingEligibility(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * PRA-11: "Government Reimbursement Billing Eligibility" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CE removePra11_GovernmentReimbursementBillingEligibility(int rep) throws HL7Exception { 
        return (CE) super.removeRepetition(11, rep);
    }




    /**
     * Returns
     * PRA-12: "Set ID - PRA" - creates it if necessary
     */
    public SI getSetIDPRA() { 
        SI ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * PRA-12: "Set ID - PRA" - creates it if necessary
     */
    public SI getPra12_SetIDPRA() { 
        SI ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new CE(getMessage());
          case 1: return new CE(getMessage());
          case 2: return new IS(getMessage(), new Integer( 186 ));
          case 3: return new ID(getMessage(), new Integer( 187 ));
          case 4: return new SPD(getMessage());
          case 5: return new PLN(getMessage());
          case 6: return new PIP(getMessage());
          case 7: return new DT(getMessage());
          case 8: return new CE(getMessage());
          case 9: return new DT(getMessage());
          case 10: return new CE(getMessage());
          case 11: return new SI(getMessage());
          default: return null;
       }
   }


}

