/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v24.segment;

// import ca.uhn.hl7v2.model.v24.group.*;
import ca.uhn.hl7v2.model.v24.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 QRF message segment (Original Style Query Filter). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>QRF-1: Where Subject Filter (ST) <b> repeating</b>
     * <li>QRF-2: When Data Start Date/Time (TS) <b>optional </b>
     * <li>QRF-3: When Data End Date/Time (TS) <b>optional </b>
     * <li>QRF-4: What User Qualifier (ST) <b>optional repeating</b>
     * <li>QRF-5: Other QRY Subject Filter (ST) <b>optional repeating</b>
     * <li>QRF-6: Which Date/Time Qualifier (ID) <b>optional repeating</b>
     * <li>QRF-7: Which Date/Time Status Qualifier (ID) <b>optional repeating</b>
     * <li>QRF-8: Date/Time Selection Qualifier (ID) <b>optional repeating</b>
     * <li>QRF-9: When Quantity/Timing Qualifier (TQ) <b>optional </b>
     * <li>QRF-10: Search Confidence Threshold (NM) <b>optional </b>
 * </ul>
 */
public class QRF extends AbstractSegment {

    /** 
     * Creates a new QRF segment
     */
    public QRF(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(ST.class, true, 0, 20, new Object[]{ getMessage(), new Integer(0) }, "Where Subject Filter");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "When Data Start Date/Time");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "When Data End Date/Time");
                                  this.add(ST.class, false, 0, 60, new Object[]{ getMessage(), new Integer(0) }, "What User Qualifier");
                                  this.add(ST.class, false, 0, 60, new Object[]{ getMessage(), new Integer(0) }, "Other QRY Subject Filter");
                                  this.add(ID.class, false, 0, 12, new Object[]{ getMessage() }, "Which Date/Time Qualifier");
                                  this.add(ID.class, false, 0, 12, new Object[]{ getMessage() }, "Which Date/Time Status Qualifier");
                                  this.add(ID.class, false, 0, 12, new Object[]{ getMessage() }, "Date/Time Selection Qualifier");
                                  this.add(TQ.class, false, 1, 60, new Object[]{ getMessage(), new Integer(0) }, "When Quantity/Timing Qualifier");
                                  this.add(NM.class, false, 1, 10, new Object[]{ getMessage(), new Integer(0) }, "Search Confidence Threshold");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating QRF - this is probably a bug in the source code generator.", e);
       }
    }


    /**
     * Returns all repetitions of Where Subject Filter (QRF-1).
     */
    public ST[] getWhereSubjectFilter() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(1);  
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ST)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRF-1: "Where Subject Filter" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getWhereSubjectFilter(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRF-1: "Where Subject Filter" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getQrf1_WhereSubjectFilter(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(1, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * QRF-1: "Where Subject Filter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertWhereSubjectFilter(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(1, rep);
    }



    /**
     * Inserts a repetition of
     * QRF-1: "Where Subject Filter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertQrf1_WhereSubjectFilter(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * QRF-1: "Where Subject Filter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeWhereSubjectFilter(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(1, rep);
    }


    /**
     * Removes a repetition of
     * QRF-1: "Where Subject Filter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeQrf1_WhereSubjectFilter(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(1, rep);
    }




    /**
     * Returns
     * QRF-2: "When Data Start Date/Time" - creates it if necessary
     */
    public TS getWhenDataStartDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * QRF-2: "When Data Start Date/Time" - creates it if necessary
     */
    public TS getQrf2_WhenDataStartDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * QRF-3: "When Data End Date/Time" - creates it if necessary
     */
    public TS getWhenDataEndDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * QRF-3: "When Data End Date/Time" - creates it if necessary
     */
    public TS getQrf3_WhenDataEndDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of What User Qualifier (QRF-4).
     */
    public ST[] getWhatUserQualifier() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(4);  
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ST)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRF-4: "What User Qualifier" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getWhatUserQualifier(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRF-4: "What User Qualifier" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getQrf4_WhatUserQualifier(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * QRF-4: "What User Qualifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertWhatUserQualifier(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(4, rep);
    }



    /**
     * Inserts a repetition of
     * QRF-4: "What User Qualifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertQrf4_WhatUserQualifier(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * QRF-4: "What User Qualifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeWhatUserQualifier(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * QRF-4: "What User Qualifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeQrf4_WhatUserQualifier(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(4, rep);
    }



    /**
     * Returns all repetitions of Other QRY Subject Filter (QRF-5).
     */
    public ST[] getOtherQRYSubjectFilter() {
        ST[] ret = null;
        try {
            Type[] t = this.getField(5);  
            ret = new ST[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ST)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRF-5: "Other QRY Subject Filter" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getOtherQRYSubjectFilter(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRF-5: "Other QRY Subject Filter" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ST getQrf5_OtherQRYSubjectFilter(int rep) { 
        ST ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * QRF-5: "Other QRY Subject Filter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertOtherQRYSubjectFilter(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(5, rep);
    }



    /**
     * Inserts a repetition of
     * QRF-5: "Other QRY Subject Filter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST insertQrf5_OtherQRYSubjectFilter(int rep) throws HL7Exception { 
        return (ST) super.insertRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * QRF-5: "Other QRY Subject Filter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeOtherQRYSubjectFilter(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * QRF-5: "Other QRY Subject Filter" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ST removeQrf5_OtherQRYSubjectFilter(int rep) throws HL7Exception { 
        return (ST) super.removeRepetition(5, rep);
    }



    /**
     * Returns all repetitions of Which Date/Time Qualifier (QRF-6).
     */
    public ID[] getWhichDateTimeQualifier() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(6);  
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ID)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRF-6: "Which Date/Time Qualifier" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getWhichDateTimeQualifier(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRF-6: "Which Date/Time Qualifier" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getQrf6_WhichDateTimeQualifier(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * QRF-6: "Which Date/Time Qualifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertWhichDateTimeQualifier(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(6, rep);
    }



    /**
     * Inserts a repetition of
     * QRF-6: "Which Date/Time Qualifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertQrf6_WhichDateTimeQualifier(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * QRF-6: "Which Date/Time Qualifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeWhichDateTimeQualifier(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * QRF-6: "Which Date/Time Qualifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeQrf6_WhichDateTimeQualifier(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(6, rep);
    }



    /**
     * Returns all repetitions of Which Date/Time Status Qualifier (QRF-7).
     */
    public ID[] getWhichDateTimeStatusQualifier() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(7);  
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ID)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRF-7: "Which Date/Time Status Qualifier" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getWhichDateTimeStatusQualifier(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRF-7: "Which Date/Time Status Qualifier" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getQrf7_WhichDateTimeStatusQualifier(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * QRF-7: "Which Date/Time Status Qualifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertWhichDateTimeStatusQualifier(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(7, rep);
    }



    /**
     * Inserts a repetition of
     * QRF-7: "Which Date/Time Status Qualifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertQrf7_WhichDateTimeStatusQualifier(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * QRF-7: "Which Date/Time Status Qualifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeWhichDateTimeStatusQualifier(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * QRF-7: "Which Date/Time Status Qualifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeQrf7_WhichDateTimeStatusQualifier(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(7, rep);
    }



    /**
     * Returns all repetitions of Date/Time Selection Qualifier (QRF-8).
     */
    public ID[] getDateTimeSelectionQualifier() {
        ID[] ret = null;
        try {
            Type[] t = this.getField(8);  
            ret = new ID[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (ID)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRF-8: "Date/Time Selection Qualifier" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getDateTimeSelectionQualifier(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * QRF-8: "Date/Time Selection Qualifier" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public ID getQrf8_DateTimeSelectionQualifier(int rep) { 
        ID ret = null;
        try {
            Type t = this.getField(8, rep);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Inserts a repetition of
     * QRF-8: "Date/Time Selection Qualifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertDateTimeSelectionQualifier(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(8, rep);
    }



    /**
     * Inserts a repetition of
     * QRF-8: "Date/Time Selection Qualifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID insertQrf8_DateTimeSelectionQualifier(int rep) throws HL7Exception { 
        return (ID) super.insertRepetition(8, rep);
    }


    /**
     * Removes a repetition of
     * QRF-8: "Date/Time Selection Qualifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeDateTimeSelectionQualifier(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(8, rep);
    }


    /**
     * Removes a repetition of
     * QRF-8: "Date/Time Selection Qualifier" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public ID removeQrf8_DateTimeSelectionQualifier(int rep) throws HL7Exception { 
        return (ID) super.removeRepetition(8, rep);
    }




    /**
     * Returns
     * QRF-9: "When Quantity/Timing Qualifier" - creates it if necessary
     */
    public TQ getWhenQuantityTimingQualifier() { 
        TQ ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (TQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * QRF-9: "When Quantity/Timing Qualifier" - creates it if necessary
     */
    public TQ getQrf9_WhenQuantityTimingQualifier() { 
        TQ ret = null;
        try {
            Type t = this.getField(9, 0);
            ret = (TQ)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * QRF-10: "Search Confidence Threshold" - creates it if necessary
     */
    public NM getSearchConfidenceThreshold() { 
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * QRF-10: "Search Confidence Threshold" - creates it if necessary
     */
    public NM getQrf10_SearchConfidenceThreshold() { 
        NM ret = null;
        try {
            Type t = this.getField(10, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new ST(getMessage());
          case 1: return new TS(getMessage());
          case 2: return new TS(getMessage());
          case 3: return new ST(getMessage());
          case 4: return new ST(getMessage());
          case 5: return new ID(getMessage(), new Integer( 156 ));
          case 6: return new ID(getMessage(), new Integer( 157 ));
          case 7: return new ID(getMessage(), new Integer( 158 ));
          case 8: return new TQ(getMessage());
          case 9: return new NM(getMessage());
          default: return null;
       }
   }


}

