/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.CSU_C09_STUDY_OBSERVATION;
import ca.uhn.hl7v2.model.v24.group.CSU_C09_STUDY_PHARM;
import ca.uhn.hl7v2.model.v24.segment.CSS;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class CSU_C09_STUDY_SCHEDULE
extends AbstractGroup {
    public CSU_C09_STUDY_SCHEDULE(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CSS.class, false, false);
            this.add(CSU_C09_STUDY_OBSERVATION.class, true, true);
            this.add(CSU_C09_STUDY_PHARM.class, true, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating CSU_C09_STUDY_SCHEDULE - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public CSS getCSS() {
        CSS ret = null;
        try {
            ret = (CSS)this.get("CSS");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CSU_C09_STUDY_OBSERVATION getSTUDY_OBSERVATION() {
        CSU_C09_STUDY_OBSERVATION ret = null;
        try {
            ret = (CSU_C09_STUDY_OBSERVATION)this.get("STUDY_OBSERVATION");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CSU_C09_STUDY_OBSERVATION getSTUDY_OBSERVATION(int rep) {
        CSU_C09_STUDY_OBSERVATION ret = null;
        try {
            ret = (CSU_C09_STUDY_OBSERVATION)this.get("STUDY_OBSERVATION", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSTUDY_OBSERVATIONReps() {
        int reps = -1;
        try {
            reps = this.getAll("STUDY_OBSERVATION").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertSTUDY_OBSERVATION(CSU_C09_STUDY_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("STUDY_OBSERVATION", (Structure)structure, rep);
    }

    public CSU_C09_STUDY_OBSERVATION insertSTUDY_OBSERVATION(int rep) throws HL7Exception {
        return (CSU_C09_STUDY_OBSERVATION)super.insertRepetition("STUDY_OBSERVATION", rep);
    }

    public CSU_C09_STUDY_OBSERVATION removeSTUDY_OBSERVATION(int rep) throws HL7Exception {
        return (CSU_C09_STUDY_OBSERVATION)super.removeRepetition("STUDY_OBSERVATION", rep);
    }

    public CSU_C09_STUDY_PHARM getSTUDY_PHARM() {
        CSU_C09_STUDY_PHARM ret = null;
        try {
            ret = (CSU_C09_STUDY_PHARM)this.get("STUDY_PHARM");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public CSU_C09_STUDY_PHARM getSTUDY_PHARM(int rep) {
        CSU_C09_STUDY_PHARM ret = null;
        try {
            ret = (CSU_C09_STUDY_PHARM)this.get("STUDY_PHARM", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getSTUDY_PHARMReps() {
        int reps = -1;
        try {
            reps = this.getAll("STUDY_PHARM").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertSTUDY_PHARM(CSU_C09_STUDY_PHARM structure, int rep) throws HL7Exception {
        super.insertRepetition("STUDY_PHARM", (Structure)structure, rep);
    }

    public CSU_C09_STUDY_PHARM insertSTUDY_PHARM(int rep) throws HL7Exception {
        return (CSU_C09_STUDY_PHARM)super.insertRepetition("STUDY_PHARM", rep);
    }

    public CSU_C09_STUDY_PHARM removeSTUDY_PHARM(int rep) throws HL7Exception {
        return (CSU_C09_STUDY_PHARM)super.removeRepetition("STUDY_PHARM", rep);
    }
}

