/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v24.datatype;

import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.log.HapiLogFactory;

/**
 * <p>Represents an HL7 VID (version identifier) data type. 
 * This type consists of the following components:</p>
 * <ul>
 * <li>version ID (ID)
 * <li>internationalization code (CE)
 * <li>international version ID (CE)
 * </ul>
 */
public class VID extends AbstractType implements Composite {

    private Type[] data;

    /** 
     * Creates a new VID type
     */
    public VID(Message message) {
        super(message);
        init();
    }

    private void init() {
        data = new Type[3];    
        data[0] = new ID(getMessage(), 0);
        data[1] = new CE(getMessage());
        data[2] = new CE(getMessage());
    }


    /**
     * Returns an array containing the data elements.
     */
    public Type[] getComponents() { 
        return this.data; 
    }

    /**
     * Returns an individual data component.
     *
     * @param number The component number (0-indexed)
     * @throws DataTypeException if the given element number is out of range.
     */
    public Type getComponent(int number) throws DataTypeException { 

        try { 
            return this.data[number]; 
        } catch (ArrayIndexOutOfBoundsException e) { 
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + getClass().getName() + " has only " + this.data.length + " components)"); 
        } 
    } 


    /**
     * Returns version ID (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getVersionID() {
       ID ret = null;
       try {
          ret = (ID)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns version ID (component #1).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public ID getVid1_VersionID() {
       ID ret = null;
       try {
          ret = (ID)getComponent(0);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns internationalization code (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getInternationalizationCode() {
       CE ret = null;
       try {
          ret = (CE)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns internationalization code (component #2).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getVid2_InternationalizationCode() {
       CE ret = null;
       try {
          ret = (CE)getComponent(1);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns international version ID (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getInternationalVersionID() {
       CE ret = null;
       try {
          ret = (CE)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    
    /**
     * Returns international version ID (component #3).  This is a convenience method that saves you from 
     * casting and handling an exception.
     */
    public CE getVid3_InternationalVersionID() {
       CE ret = null;
       try {
          ret = (CE)getComponent(2);
       } catch (DataTypeException e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem accessing known data type component - this is a bug.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }



}

