/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.model.v24.segment.*;

import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.GenericSegment;

/**
 * <p>Represents a DFT_P03_FINANCIAL_COMMON_ORDER group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                 * <li>1: ORC (Common Order) <b>optional </b></li>
                 * <li>2: DFT_P03_FINANCIAL_ORDER (a Group object) <b>optional </b></li>
                 * <li>3: DFT_P03_FINANCIAL_OBSERVATION (a Group object) <b>optional repeating</b></li>
 * </ul>
 */
public class DFT_P03_FINANCIAL_COMMON_ORDER extends AbstractGroup {

    /** 
     * Creates a new DFT_P03_FINANCIAL_COMMON_ORDER group
     */
    public DFT_P03_FINANCIAL_COMMON_ORDER(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                          this.add(ORC.class, false, false);
                          this.add(DFT_P03_FINANCIAL_ORDER.class, false, false);
                          this.add(DFT_P03_FINANCIAL_OBSERVATION.class, false, true);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating DFT_P03_FINANCIAL_COMMON_ORDER - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.4"
     */
    public String getVersion() {
       return "2.4";
    }



    /**
     * Returns
     * ORC (Common Order) - creates it if necessary
     */
    public ORC getORC() { 
       ORC ret = null;
       try {
          ret = (ORC)this.get("ORC");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * FINANCIAL_ORDER (a Group object) - creates it if necessary
     */
    public DFT_P03_FINANCIAL_ORDER getFINANCIAL_ORDER() { 
       DFT_P03_FINANCIAL_ORDER ret = null;
       try {
          ret = (DFT_P03_FINANCIAL_ORDER)this.get("FINANCIAL_ORDER");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }




    /**
     * Returns
     * the first repetition of 
     * FINANCIAL_OBSERVATION (a Group object) - creates it if necessary
     */
    public DFT_P03_FINANCIAL_OBSERVATION getFINANCIAL_OBSERVATION() { 
       DFT_P03_FINANCIAL_OBSERVATION ret = null;
       try {
          ret = (DFT_P03_FINANCIAL_OBSERVATION)this.get("FINANCIAL_OBSERVATION");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }


    /**
     * Returns a specific repetition of
     * FINANCIAL_OBSERVATION (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public DFT_P03_FINANCIAL_OBSERVATION getFINANCIAL_OBSERVATION(int rep) { 
       DFT_P03_FINANCIAL_OBSERVATION ret = null;
       try {
          ret = (DFT_P03_FINANCIAL_OBSERVATION)this.get("FINANCIAL_OBSERVATION", rep);
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
          throw new RuntimeException(e);
       }
       return ret;
    }

    /** 
     * Returns the number of existing repetitions of FINANCIAL_OBSERVATION 
     */ 
    public int getFINANCIAL_OBSERVATIONReps() { 
        int reps = -1; 
        try { 
            reps = this.getAll("FINANCIAL_OBSERVATION").length; 
        } catch (HL7Exception e) { 
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator."; 
            HapiLogFactory.getHapiLog(this.getClass()).error(message, e); 
            throw new RuntimeException(message);
        } 
        return reps; 
    } 

    /**
     * Inserts a specific repetition of FINANCIAL_OBSERVATION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertFINANCIAL_OBSERVATION(DFT_P03_FINANCIAL_OBSERVATION structure, int rep) throws HL7Exception { 
       super.insertRepetition("FINANCIAL_OBSERVATION", structure, rep);
    }


    /**
     * Inserts a specific repetition of FINANCIAL_OBSERVATION (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public DFT_P03_FINANCIAL_OBSERVATION insertFINANCIAL_OBSERVATION(int rep) throws HL7Exception { 
       return (DFT_P03_FINANCIAL_OBSERVATION)super.insertRepetition("FINANCIAL_OBSERVATION", rep);
    }


    /**
     * Removes a specific repetition of FINANCIAL_OBSERVATION (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public DFT_P03_FINANCIAL_OBSERVATION removeFINANCIAL_OBSERVATION(int rep) throws HL7Exception { 
       return (DFT_P03_FINANCIAL_OBSERVATION)super.removeRepetition("FINANCIAL_OBSERVATION", rep);
    }



}

