/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v24.segment;

// import ca.uhn.hl7v2.model.v24.group.*;
import ca.uhn.hl7v2.model.v24.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 GP1 message segment (Grouping/Reimbursement - Visit). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>GP1-1: Type of Bill Code (IS) <b> </b>
     * <li>GP1-2: Revenue Code (IS) <b>optional repeating</b>
     * <li>GP1-3: Overall Claim Disposition Code (IS) <b>optional </b>
     * <li>GP1-4: OCE Edits per Visit Code (IS) <b>optional repeating</b>
     * <li>GP1-5: Outlier Cost (CP) <b>optional </b>
 * </ul>
 */
public class GP1 extends AbstractSegment {

    /** 
     * Creates a new GP1 segment
     */
    public GP1(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(IS.class, true, 1, 3, new Object[]{ getMessage() }, "Type of Bill Code");
                                  this.add(IS.class, false, 0, 3, new Object[]{ getMessage() }, "Revenue Code");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "Overall Claim Disposition Code");
                                  this.add(IS.class, false, 0, 2, new Object[]{ getMessage() }, "OCE Edits per Visit Code");
                                  this.add(CP.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Outlier Cost");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating GP1 - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * GP1-1: "Type of Bill Code" - creates it if necessary
     */
    public IS getTypeOfBillCode() { 
        IS ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GP1-1: "Type of Bill Code" - creates it if necessary
     */
    public IS getGp11_TypeOfBillCode() { 
        IS ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Revenue Code (GP1-2).
     */
    public IS[] getRevenueCode() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(2);  
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (IS)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Revenue Code (GP1-2).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getRevenueCodeReps() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(2);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * GP1-2: "Revenue Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getRevenueCode(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GP1-2: "Revenue Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getGp12_RevenueCode(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(2, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Revenue Code (GP1-2).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getGp12_RevenueCodeReps() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(2);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * GP1-2: "Revenue Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertRevenueCode(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(2, rep);
    }



    /**
     * Inserts a repetition of
     * GP1-2: "Revenue Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertGp12_RevenueCode(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * GP1-2: "Revenue Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removeRevenueCode(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(2, rep);
    }


    /**
     * Removes a repetition of
     * GP1-2: "Revenue Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removeGp12_RevenueCode(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(2, rep);
    }




    /**
     * Returns
     * GP1-3: "Overall Claim Disposition Code" - creates it if necessary
     */
    public IS getOverallClaimDispositionCode() { 
        IS ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GP1-3: "Overall Claim Disposition Code" - creates it if necessary
     */
    public IS getGp13_OverallClaimDispositionCode() { 
        IS ret = null;
        try {
            Type t = this.getField(3, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of OCE Edits per Visit Code (GP1-4).
     */
    public IS[] getOCEEditsPerVisitCode() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(4);  
            ret = new IS[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (IS)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of OCE Edits per Visit Code (GP1-4).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getOCEEditsPerVisitCodeReps() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(4);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * GP1-4: "OCE Edits per Visit Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getOCEEditsPerVisitCode(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * GP1-4: "OCE Edits per Visit Code" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public IS getGp14_OCEEditsPerVisitCode(int rep) { 
        IS ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of OCE Edits per Visit Code (GP1-4).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getGp14_OCEEditsPerVisitCodeReps() {
        IS[] ret = null;
        try {
            Type[] t = this.getField(4);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * GP1-4: "OCE Edits per Visit Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertOCEEditsPerVisitCode(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(4, rep);
    }



    /**
     * Inserts a repetition of
     * GP1-4: "OCE Edits per Visit Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS insertGp14_OCEEditsPerVisitCode(int rep) throws HL7Exception { 
        return (IS) super.insertRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * GP1-4: "OCE Edits per Visit Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removeOCEEditsPerVisitCode(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * GP1-4: "OCE Edits per Visit Code" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public IS removeGp14_OCEEditsPerVisitCode(int rep) throws HL7Exception { 
        return (IS) super.removeRepetition(4, rep);
    }




    /**
     * Returns
     * GP1-5: "Outlier Cost" - creates it if necessary
     */
    public CP getOutlierCost() { 
        CP ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * GP1-5: "Outlier Cost" - creates it if necessary
     */
    public CP getGp15_OutlierCost() { 
        CP ret = null;
        try {
            Type t = this.getField(5, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }





    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new IS(getMessage(), new Integer( 455 ));
          case 1: return new IS(getMessage(), new Integer( 456 ));
          case 2: return new IS(getMessage(), new Integer( 457 ));
          case 3: return new IS(getMessage(), new Integer( 458 ));
          case 4: return new CP(getMessage());
          default: return null;
       }
   }


}

