/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 */

package ca.uhn.hl7v2.model.v24.segment;

// import ca.uhn.hl7v2.model.v24.group.*;
import ca.uhn.hl7v2.model.v24.datatype.*;
import ca.uhn.log.HapiLogFactory;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Varies;

/**
 *<p>Represents an HL7 IN1 message segment (Insurance). 
 * This segment has the following fields:</p>
 * <ul>
     * <li>IN1-1: Set ID - IN1 (SI) <b> </b>
     * <li>IN1-2: Insurance Plan ID (CE) <b> </b>
     * <li>IN1-3: Insurance Company ID (CX) <b> repeating</b>
     * <li>IN1-4: Insurance Company Name (XON) <b>optional repeating</b>
     * <li>IN1-5: Insurance Company Address (XAD) <b>optional repeating</b>
     * <li>IN1-6: Insurance Co Contact Person (XPN) <b>optional repeating</b>
     * <li>IN1-7: Insurance Co Phone Number (XTN) <b>optional repeating</b>
     * <li>IN1-8: Group Number (ST) <b>optional </b>
     * <li>IN1-9: Group Name (XON) <b>optional repeating</b>
     * <li>IN1-10: Insured's Group Emp ID (CX) <b>optional repeating</b>
     * <li>IN1-11: Insured's Group Emp Name (XON) <b>optional repeating</b>
     * <li>IN1-12: Plan Effective Date (DT) <b>optional </b>
     * <li>IN1-13: Plan Expiration Date (DT) <b>optional </b>
     * <li>IN1-14: Authorization Information (AUI) <b>optional </b>
     * <li>IN1-15: Plan Type (IS) <b>optional </b>
     * <li>IN1-16: Name Of Insured (XPN) <b>optional repeating</b>
     * <li>IN1-17: Insured's Relationship To Patient (CE) <b>optional </b>
     * <li>IN1-18: Insured's Date Of Birth (TS) <b>optional </b>
     * <li>IN1-19: Insured's Address (XAD) <b>optional repeating</b>
     * <li>IN1-20: Assignment Of Benefits (IS) <b>optional </b>
     * <li>IN1-21: Coordination Of Benefits (IS) <b>optional </b>
     * <li>IN1-22: Coord Of Ben. Priority (ST) <b>optional </b>
     * <li>IN1-23: Notice Of Admission Flag (ID) <b>optional </b>
     * <li>IN1-24: Notice Of Admission Date (DT) <b>optional </b>
     * <li>IN1-25: Report Of Eligibility Flag (ID) <b>optional </b>
     * <li>IN1-26: Report Of Eligibility Date (DT) <b>optional </b>
     * <li>IN1-27: Release Information Code (IS) <b>optional </b>
     * <li>IN1-28: Pre-Admit Cert (PAC) (ST) <b>optional </b>
     * <li>IN1-29: Verification Date/Time (TS) <b>optional </b>
     * <li>IN1-30: Verification By (XCN) <b>optional repeating</b>
     * <li>IN1-31: Type Of Agreement Code (IS) <b>optional </b>
     * <li>IN1-32: Billing Status (IS) <b>optional </b>
     * <li>IN1-33: Lifetime Reserve Days (NM) <b>optional </b>
     * <li>IN1-34: Delay Before L.R. Day (NM) <b>optional </b>
     * <li>IN1-35: Company Plan Code (IS) <b>optional </b>
     * <li>IN1-36: Policy Number (ST) <b>optional </b>
     * <li>IN1-37: Policy Deductible (CP) <b>optional </b>
     * <li>IN1-38: Policy Limit - Amount (CP) <b>optional </b>
     * <li>IN1-39: Policy Limit - Days (NM) <b>optional </b>
     * <li>IN1-40: Room Rate - Semi-Private (CP) <b>optional </b>
     * <li>IN1-41: Room Rate - Private (CP) <b>optional </b>
     * <li>IN1-42: Insured's Employment Status (CE) <b>optional </b>
     * <li>IN1-43: Insured's Administrative Sex (IS) <b>optional </b>
     * <li>IN1-44: Insured's Employer's Address (XAD) <b>optional repeating</b>
     * <li>IN1-45: Verification Status (ST) <b>optional </b>
     * <li>IN1-46: Prior Insurance Plan ID (IS) <b>optional </b>
     * <li>IN1-47: Coverage Type (IS) <b>optional </b>
     * <li>IN1-48: Handicap (IS) <b>optional </b>
     * <li>IN1-49: Insured's ID Number (CX) <b>optional repeating</b>
 * </ul>
 */
public class IN1 extends AbstractSegment {

    /** 
     * Creates a new IN1 segment
     */
    public IN1(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(SI.class, true, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Set ID - IN1");
                                  this.add(CE.class, true, 1, 250, new Object[]{ getMessage(), new Integer(72) }, "Insurance Plan ID");
                                  this.add(CX.class, true, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Insurance Company ID");
                                  this.add(XON.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Insurance Company Name");
                                  this.add(XAD.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Insurance Company Address");
                                  this.add(XPN.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Insurance Co Contact Person");
                                  this.add(XTN.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Insurance Co Phone Number");
                                  this.add(ST.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Group Number");
                                  this.add(XON.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Group Name");
                                  this.add(CX.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Insured's Group Emp ID");
                                  this.add(XON.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Insured's Group Emp Name");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Plan Effective Date");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Plan Expiration Date");
                                  this.add(AUI.class, false, 1, 250, new Object[]{ getMessage(), new Integer(0) }, "Authorization Information");
                                  this.add(IS.class, false, 1, 3, new Object[]{ getMessage() }, "Plan Type");
                                  this.add(XPN.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Name Of Insured");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(63) }, "Insured's Relationship To Patient");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Insured's Date Of Birth");
                                  this.add(XAD.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Insured's Address");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Assignment Of Benefits");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Coordination Of Benefits");
                                  this.add(ST.class, false, 1, 2, new Object[]{ getMessage(), new Integer(0) }, "Coord Of Ben. Priority");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Notice Of Admission Flag");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Notice Of Admission Date");
                                  this.add(ID.class, false, 1, 1, new Object[]{ getMessage() }, "Report Of Eligibility Flag");
                                  this.add(DT.class, false, 1, 8, new Object[]{ getMessage(), new Integer(0) }, "Report Of Eligibility Date");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Release Information Code");
                                  this.add(ST.class, false, 1, 15, new Object[]{ getMessage(), new Integer(0) }, "Pre-Admit Cert (PAC)");
                                  this.add(TS.class, false, 1, 26, new Object[]{ getMessage(), new Integer(0) }, "Verification Date/Time");
                                  this.add(XCN.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Verification By");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Type Of Agreement Code");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Billing Status");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Lifetime Reserve Days");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Delay Before L.R. Day");
                                  this.add(IS.class, false, 1, 8, new Object[]{ getMessage() }, "Company Plan Code");
                                  this.add(ST.class, false, 1, 15, new Object[]{ getMessage(), new Integer(0) }, "Policy Number");
                                  this.add(CP.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Policy Deductible");
                                  this.add(CP.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Policy Limit - Amount");
                                  this.add(NM.class, false, 1, 4, new Object[]{ getMessage(), new Integer(0) }, "Policy Limit - Days");
                                  this.add(CP.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Room Rate - Semi-Private");
                                  this.add(CP.class, false, 1, 12, new Object[]{ getMessage(), new Integer(0) }, "Room Rate - Private");
                                  this.add(CE.class, false, 1, 250, new Object[]{ getMessage(), new Integer(66) }, "Insured's Employment Status");
                                  this.add(IS.class, false, 1, 1, new Object[]{ getMessage() }, "Insured's Administrative Sex");
                                  this.add(XAD.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Insured's Employer's Address");
                                  this.add(ST.class, false, 1, 2, new Object[]{ getMessage(), new Integer(0) }, "Verification Status");
                                  this.add(IS.class, false, 1, 8, new Object[]{ getMessage() }, "Prior Insurance Plan ID");
                                  this.add(IS.class, false, 1, 3, new Object[]{ getMessage() }, "Coverage Type");
                                  this.add(IS.class, false, 1, 2, new Object[]{ getMessage() }, "Handicap");
                                  this.add(CX.class, false, 0, 250, new Object[]{ getMessage(), new Integer(0) }, "Insured's ID Number");
       } catch(HL7Exception e) {
          HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating IN1 - this is probably a bug in the source code generator.", e);
       }
    }



    /**
     * Returns
     * IN1-1: "Set ID - IN1" - creates it if necessary
     */
    public SI getSetIDIN1() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-1: "Set ID - IN1" - creates it if necessary
     */
    public SI getIn11_SetIDIN1() { 
        SI ret = null;
        try {
            Type t = this.getField(1, 0);
            ret = (SI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-2: "Insurance Plan ID" - creates it if necessary
     */
    public CE getInsurancePlanID() { 
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-2: "Insurance Plan ID" - creates it if necessary
     */
    public CE getIn12_InsurancePlanID() { 
        CE ret = null;
        try {
            Type t = this.getField(2, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Insurance Company ID (IN1-3).
     */
    public CX[] getInsuranceCompanyID() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(3);  
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CX)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insurance Company ID (IN1-3).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getInsuranceCompanyIDReps() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(3);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * IN1-3: "Insurance Company ID" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getInsuranceCompanyID(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN1-3: "Insurance Company ID" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getIn13_InsuranceCompanyID(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(3, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insurance Company ID (IN1-3).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getIn13_InsuranceCompanyIDReps() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(3);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * IN1-3: "Insurance Company ID" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertInsuranceCompanyID(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(3, rep);
    }



    /**
     * Inserts a repetition of
     * IN1-3: "Insurance Company ID" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertIn13_InsuranceCompanyID(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * IN1-3: "Insurance Company ID" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removeInsuranceCompanyID(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(3, rep);
    }


    /**
     * Removes a repetition of
     * IN1-3: "Insurance Company ID" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removeIn13_InsuranceCompanyID(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(3, rep);
    }



    /**
     * Returns all repetitions of Insurance Company Name (IN1-4).
     */
    public XON[] getInsuranceCompanyName() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(4);  
            ret = new XON[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XON)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insurance Company Name (IN1-4).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getInsuranceCompanyNameReps() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(4);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * IN1-4: "Insurance Company Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XON getInsuranceCompanyName(int rep) { 
        XON ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN1-4: "Insurance Company Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XON getIn14_InsuranceCompanyName(int rep) { 
        XON ret = null;
        try {
            Type t = this.getField(4, rep);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insurance Company Name (IN1-4).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getIn14_InsuranceCompanyNameReps() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(4);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * IN1-4: "Insurance Company Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON insertInsuranceCompanyName(int rep) throws HL7Exception { 
        return (XON) super.insertRepetition(4, rep);
    }



    /**
     * Inserts a repetition of
     * IN1-4: "Insurance Company Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON insertIn14_InsuranceCompanyName(int rep) throws HL7Exception { 
        return (XON) super.insertRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * IN1-4: "Insurance Company Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON removeInsuranceCompanyName(int rep) throws HL7Exception { 
        return (XON) super.removeRepetition(4, rep);
    }


    /**
     * Removes a repetition of
     * IN1-4: "Insurance Company Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON removeIn14_InsuranceCompanyName(int rep) throws HL7Exception { 
        return (XON) super.removeRepetition(4, rep);
    }



    /**
     * Returns all repetitions of Insurance Company Address (IN1-5).
     */
    public XAD[] getInsuranceCompanyAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(5);  
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XAD)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insurance Company Address (IN1-5).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getInsuranceCompanyAddressReps() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(5);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * IN1-5: "Insurance Company Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getInsuranceCompanyAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN1-5: "Insurance Company Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getIn15_InsuranceCompanyAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(5, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insurance Company Address (IN1-5).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getIn15_InsuranceCompanyAddressReps() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(5);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * IN1-5: "Insurance Company Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertInsuranceCompanyAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(5, rep);
    }



    /**
     * Inserts a repetition of
     * IN1-5: "Insurance Company Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertIn15_InsuranceCompanyAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * IN1-5: "Insurance Company Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removeInsuranceCompanyAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(5, rep);
    }


    /**
     * Removes a repetition of
     * IN1-5: "Insurance Company Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removeIn15_InsuranceCompanyAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(5, rep);
    }



    /**
     * Returns all repetitions of Insurance Co Contact Person (IN1-6).
     */
    public XPN[] getInsuranceCoContactPerson() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(6);  
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XPN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insurance Co Contact Person (IN1-6).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getInsuranceCoContactPersonReps() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(6);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * IN1-6: "Insurance Co Contact Person" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getInsuranceCoContactPerson(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN1-6: "Insurance Co Contact Person" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getIn16_InsuranceCoContactPerson(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(6, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insurance Co Contact Person (IN1-6).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getIn16_InsuranceCoContactPersonReps() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(6);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * IN1-6: "Insurance Co Contact Person" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertInsuranceCoContactPerson(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(6, rep);
    }



    /**
     * Inserts a repetition of
     * IN1-6: "Insurance Co Contact Person" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertIn16_InsuranceCoContactPerson(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * IN1-6: "Insurance Co Contact Person" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removeInsuranceCoContactPerson(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(6, rep);
    }


    /**
     * Removes a repetition of
     * IN1-6: "Insurance Co Contact Person" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removeIn16_InsuranceCoContactPerson(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(6, rep);
    }



    /**
     * Returns all repetitions of Insurance Co Phone Number (IN1-7).
     */
    public XTN[] getInsuranceCoPhoneNumber() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(7);  
            ret = new XTN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XTN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insurance Co Phone Number (IN1-7).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getInsuranceCoPhoneNumberReps() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * IN1-7: "Insurance Co Phone Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getInsuranceCoPhoneNumber(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN1-7: "Insurance Co Phone Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XTN getIn17_InsuranceCoPhoneNumber(int rep) { 
        XTN ret = null;
        try {
            Type t = this.getField(7, rep);
            ret = (XTN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insurance Co Phone Number (IN1-7).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getIn17_InsuranceCoPhoneNumberReps() {
        XTN[] ret = null;
        try {
            Type[] t = this.getField(7);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * IN1-7: "Insurance Co Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertInsuranceCoPhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(7, rep);
    }



    /**
     * Inserts a repetition of
     * IN1-7: "Insurance Co Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN insertIn17_InsuranceCoPhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.insertRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * IN1-7: "Insurance Co Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeInsuranceCoPhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(7, rep);
    }


    /**
     * Removes a repetition of
     * IN1-7: "Insurance Co Phone Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XTN removeIn17_InsuranceCoPhoneNumber(int rep) throws HL7Exception { 
        return (XTN) super.removeRepetition(7, rep);
    }




    /**
     * Returns
     * IN1-8: "Group Number" - creates it if necessary
     */
    public ST getGroupNumber() { 
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-8: "Group Number" - creates it if necessary
     */
    public ST getIn18_GroupNumber() { 
        ST ret = null;
        try {
            Type t = this.getField(8, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Group Name (IN1-9).
     */
    public XON[] getGroupName() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(9);  
            ret = new XON[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XON)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Group Name (IN1-9).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getGroupNameReps() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(9);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * IN1-9: "Group Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XON getGroupName(int rep) { 
        XON ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN1-9: "Group Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XON getIn19_GroupName(int rep) { 
        XON ret = null;
        try {
            Type t = this.getField(9, rep);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Group Name (IN1-9).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getIn19_GroupNameReps() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(9);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * IN1-9: "Group Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON insertGroupName(int rep) throws HL7Exception { 
        return (XON) super.insertRepetition(9, rep);
    }



    /**
     * Inserts a repetition of
     * IN1-9: "Group Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON insertIn19_GroupName(int rep) throws HL7Exception { 
        return (XON) super.insertRepetition(9, rep);
    }


    /**
     * Removes a repetition of
     * IN1-9: "Group Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON removeGroupName(int rep) throws HL7Exception { 
        return (XON) super.removeRepetition(9, rep);
    }


    /**
     * Removes a repetition of
     * IN1-9: "Group Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON removeIn19_GroupName(int rep) throws HL7Exception { 
        return (XON) super.removeRepetition(9, rep);
    }



    /**
     * Returns all repetitions of Insured's Group Emp ID (IN1-10).
     */
    public CX[] getInsuredSGroupEmpID() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(10);  
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CX)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insured's Group Emp ID (IN1-10).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getInsuredSGroupEmpIDReps() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(10);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * IN1-10: "Insured's Group Emp ID" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getInsuredSGroupEmpID(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN1-10: "Insured's Group Emp ID" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getIn110_InsuredSGroupEmpID(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(10, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insured's Group Emp ID (IN1-10).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getIn110_InsuredSGroupEmpIDReps() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(10);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * IN1-10: "Insured's Group Emp ID" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertInsuredSGroupEmpID(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(10, rep);
    }



    /**
     * Inserts a repetition of
     * IN1-10: "Insured's Group Emp ID" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertIn110_InsuredSGroupEmpID(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(10, rep);
    }


    /**
     * Removes a repetition of
     * IN1-10: "Insured's Group Emp ID" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removeInsuredSGroupEmpID(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(10, rep);
    }


    /**
     * Removes a repetition of
     * IN1-10: "Insured's Group Emp ID" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removeIn110_InsuredSGroupEmpID(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(10, rep);
    }



    /**
     * Returns all repetitions of Insured's Group Emp Name (IN1-11).
     */
    public XON[] getInsuredSGroupEmpName() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(11);  
            ret = new XON[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XON)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insured's Group Emp Name (IN1-11).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getInsuredSGroupEmpNameReps() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(11);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * IN1-11: "Insured's Group Emp Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XON getInsuredSGroupEmpName(int rep) { 
        XON ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN1-11: "Insured's Group Emp Name" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XON getIn111_InsuredSGroupEmpName(int rep) { 
        XON ret = null;
        try {
            Type t = this.getField(11, rep);
            ret = (XON)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insured's Group Emp Name (IN1-11).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getIn111_InsuredSGroupEmpNameReps() {
        XON[] ret = null;
        try {
            Type[] t = this.getField(11);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * IN1-11: "Insured's Group Emp Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON insertInsuredSGroupEmpName(int rep) throws HL7Exception { 
        return (XON) super.insertRepetition(11, rep);
    }



    /**
     * Inserts a repetition of
     * IN1-11: "Insured's Group Emp Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON insertIn111_InsuredSGroupEmpName(int rep) throws HL7Exception { 
        return (XON) super.insertRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * IN1-11: "Insured's Group Emp Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON removeInsuredSGroupEmpName(int rep) throws HL7Exception { 
        return (XON) super.removeRepetition(11, rep);
    }


    /**
     * Removes a repetition of
     * IN1-11: "Insured's Group Emp Name" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XON removeIn111_InsuredSGroupEmpName(int rep) throws HL7Exception { 
        return (XON) super.removeRepetition(11, rep);
    }




    /**
     * Returns
     * IN1-12: "Plan Effective Date" - creates it if necessary
     */
    public DT getPlanEffectiveDate() { 
        DT ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-12: "Plan Effective Date" - creates it if necessary
     */
    public DT getIn112_PlanEffectiveDate() { 
        DT ret = null;
        try {
            Type t = this.getField(12, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-13: "Plan Expiration Date" - creates it if necessary
     */
    public DT getPlanExpirationDate() { 
        DT ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-13: "Plan Expiration Date" - creates it if necessary
     */
    public DT getIn113_PlanExpirationDate() { 
        DT ret = null;
        try {
            Type t = this.getField(13, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-14: "Authorization Information" - creates it if necessary
     */
    public AUI getAuthorizationInformation() { 
        AUI ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (AUI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-14: "Authorization Information" - creates it if necessary
     */
    public AUI getIn114_AuthorizationInformation() { 
        AUI ret = null;
        try {
            Type t = this.getField(14, 0);
            ret = (AUI)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-15: "Plan Type" - creates it if necessary
     */
    public IS getPlanType() { 
        IS ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-15: "Plan Type" - creates it if necessary
     */
    public IS getIn115_PlanType() { 
        IS ret = null;
        try {
            Type t = this.getField(15, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Name Of Insured (IN1-16).
     */
    public XPN[] getNameOfInsured() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(16);  
            ret = new XPN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XPN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Name Of Insured (IN1-16).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getNameOfInsuredReps() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(16);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * IN1-16: "Name Of Insured" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getNameOfInsured(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN1-16: "Name Of Insured" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XPN getIn116_NameOfInsured(int rep) { 
        XPN ret = null;
        try {
            Type t = this.getField(16, rep);
            ret = (XPN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Name Of Insured (IN1-16).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getIn116_NameOfInsuredReps() {
        XPN[] ret = null;
        try {
            Type[] t = this.getField(16);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * IN1-16: "Name Of Insured" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertNameOfInsured(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(16, rep);
    }



    /**
     * Inserts a repetition of
     * IN1-16: "Name Of Insured" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN insertIn116_NameOfInsured(int rep) throws HL7Exception { 
        return (XPN) super.insertRepetition(16, rep);
    }


    /**
     * Removes a repetition of
     * IN1-16: "Name Of Insured" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removeNameOfInsured(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(16, rep);
    }


    /**
     * Removes a repetition of
     * IN1-16: "Name Of Insured" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XPN removeIn116_NameOfInsured(int rep) throws HL7Exception { 
        return (XPN) super.removeRepetition(16, rep);
    }




    /**
     * Returns
     * IN1-17: "Insured's Relationship To Patient" - creates it if necessary
     */
    public CE getInsuredSRelationshipToPatient() { 
        CE ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-17: "Insured's Relationship To Patient" - creates it if necessary
     */
    public CE getIn117_InsuredSRelationshipToPatient() { 
        CE ret = null;
        try {
            Type t = this.getField(17, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-18: "Insured's Date Of Birth" - creates it if necessary
     */
    public TS getInsuredSDateOfBirth() { 
        TS ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-18: "Insured's Date Of Birth" - creates it if necessary
     */
    public TS getIn118_InsuredSDateOfBirth() { 
        TS ret = null;
        try {
            Type t = this.getField(18, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Insured's Address (IN1-19).
     */
    public XAD[] getInsuredSAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(19);  
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XAD)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insured's Address (IN1-19).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getInsuredSAddressReps() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(19);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * IN1-19: "Insured's Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getInsuredSAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN1-19: "Insured's Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getIn119_InsuredSAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(19, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insured's Address (IN1-19).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getIn119_InsuredSAddressReps() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(19);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * IN1-19: "Insured's Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertInsuredSAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(19, rep);
    }



    /**
     * Inserts a repetition of
     * IN1-19: "Insured's Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertIn119_InsuredSAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(19, rep);
    }


    /**
     * Removes a repetition of
     * IN1-19: "Insured's Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removeInsuredSAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(19, rep);
    }


    /**
     * Removes a repetition of
     * IN1-19: "Insured's Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removeIn119_InsuredSAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(19, rep);
    }




    /**
     * Returns
     * IN1-20: "Assignment Of Benefits" - creates it if necessary
     */
    public IS getAssignmentOfBenefits() { 
        IS ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-20: "Assignment Of Benefits" - creates it if necessary
     */
    public IS getIn120_AssignmentOfBenefits() { 
        IS ret = null;
        try {
            Type t = this.getField(20, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-21: "Coordination Of Benefits" - creates it if necessary
     */
    public IS getCoordinationOfBenefits() { 
        IS ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-21: "Coordination Of Benefits" - creates it if necessary
     */
    public IS getIn121_CoordinationOfBenefits() { 
        IS ret = null;
        try {
            Type t = this.getField(21, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-22: "Coord Of Ben. Priority" - creates it if necessary
     */
    public ST getCoordOfBenPriority() { 
        ST ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-22: "Coord Of Ben. Priority" - creates it if necessary
     */
    public ST getIn122_CoordOfBenPriority() { 
        ST ret = null;
        try {
            Type t = this.getField(22, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-23: "Notice Of Admission Flag" - creates it if necessary
     */
    public ID getNoticeOfAdmissionFlag() { 
        ID ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-23: "Notice Of Admission Flag" - creates it if necessary
     */
    public ID getIn123_NoticeOfAdmissionFlag() { 
        ID ret = null;
        try {
            Type t = this.getField(23, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-24: "Notice Of Admission Date" - creates it if necessary
     */
    public DT getNoticeOfAdmissionDate() { 
        DT ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-24: "Notice Of Admission Date" - creates it if necessary
     */
    public DT getIn124_NoticeOfAdmissionDate() { 
        DT ret = null;
        try {
            Type t = this.getField(24, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-25: "Report Of Eligibility Flag" - creates it if necessary
     */
    public ID getReportOfEligibilityFlag() { 
        ID ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-25: "Report Of Eligibility Flag" - creates it if necessary
     */
    public ID getIn125_ReportOfEligibilityFlag() { 
        ID ret = null;
        try {
            Type t = this.getField(25, 0);
            ret = (ID)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-26: "Report Of Eligibility Date" - creates it if necessary
     */
    public DT getReportOfEligibilityDate() { 
        DT ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-26: "Report Of Eligibility Date" - creates it if necessary
     */
    public DT getIn126_ReportOfEligibilityDate() { 
        DT ret = null;
        try {
            Type t = this.getField(26, 0);
            ret = (DT)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-27: "Release Information Code" - creates it if necessary
     */
    public IS getReleaseInformationCode() { 
        IS ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-27: "Release Information Code" - creates it if necessary
     */
    public IS getIn127_ReleaseInformationCode() { 
        IS ret = null;
        try {
            Type t = this.getField(27, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-28: "Pre-Admit Cert (PAC)" - creates it if necessary
     */
    public ST getPreAdmitCert() { 
        ST ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-28: "Pre-Admit Cert (PAC)" - creates it if necessary
     */
    public ST getIn128_PreAdmitCert() { 
        ST ret = null;
        try {
            Type t = this.getField(28, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-29: "Verification Date/Time" - creates it if necessary
     */
    public TS getVerificationDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-29: "Verification Date/Time" - creates it if necessary
     */
    public TS getIn129_VerificationDateTime() { 
        TS ret = null;
        try {
            Type t = this.getField(29, 0);
            ret = (TS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Verification By (IN1-30).
     */
    public XCN[] getVerificationBy() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(30);  
            ret = new XCN[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XCN)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Verification By (IN1-30).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getVerificationByReps() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(30);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * IN1-30: "Verification By" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XCN getVerificationBy(int rep) { 
        XCN ret = null;
        try {
            Type t = this.getField(30, rep);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN1-30: "Verification By" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XCN getIn130_VerificationBy(int rep) { 
        XCN ret = null;
        try {
            Type t = this.getField(30, rep);
            ret = (XCN)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Verification By (IN1-30).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getIn130_VerificationByReps() {
        XCN[] ret = null;
        try {
            Type[] t = this.getField(30);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * IN1-30: "Verification By" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN insertVerificationBy(int rep) throws HL7Exception { 
        return (XCN) super.insertRepetition(30, rep);
    }



    /**
     * Inserts a repetition of
     * IN1-30: "Verification By" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN insertIn130_VerificationBy(int rep) throws HL7Exception { 
        return (XCN) super.insertRepetition(30, rep);
    }


    /**
     * Removes a repetition of
     * IN1-30: "Verification By" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN removeVerificationBy(int rep) throws HL7Exception { 
        return (XCN) super.removeRepetition(30, rep);
    }


    /**
     * Removes a repetition of
     * IN1-30: "Verification By" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XCN removeIn130_VerificationBy(int rep) throws HL7Exception { 
        return (XCN) super.removeRepetition(30, rep);
    }




    /**
     * Returns
     * IN1-31: "Type Of Agreement Code" - creates it if necessary
     */
    public IS getTypeOfAgreementCode() { 
        IS ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-31: "Type Of Agreement Code" - creates it if necessary
     */
    public IS getIn131_TypeOfAgreementCode() { 
        IS ret = null;
        try {
            Type t = this.getField(31, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-32: "Billing Status" - creates it if necessary
     */
    public IS getBillingStatus() { 
        IS ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-32: "Billing Status" - creates it if necessary
     */
    public IS getIn132_BillingStatus() { 
        IS ret = null;
        try {
            Type t = this.getField(32, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-33: "Lifetime Reserve Days" - creates it if necessary
     */
    public NM getLifetimeReserveDays() { 
        NM ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-33: "Lifetime Reserve Days" - creates it if necessary
     */
    public NM getIn133_LifetimeReserveDays() { 
        NM ret = null;
        try {
            Type t = this.getField(33, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-34: "Delay Before L.R. Day" - creates it if necessary
     */
    public NM getDelayBeforeLRDay() { 
        NM ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-34: "Delay Before L.R. Day" - creates it if necessary
     */
    public NM getIn134_DelayBeforeLRDay() { 
        NM ret = null;
        try {
            Type t = this.getField(34, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-35: "Company Plan Code" - creates it if necessary
     */
    public IS getCompanyPlanCode() { 
        IS ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-35: "Company Plan Code" - creates it if necessary
     */
    public IS getIn135_CompanyPlanCode() { 
        IS ret = null;
        try {
            Type t = this.getField(35, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-36: "Policy Number" - creates it if necessary
     */
    public ST getPolicyNumber() { 
        ST ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-36: "Policy Number" - creates it if necessary
     */
    public ST getIn136_PolicyNumber() { 
        ST ret = null;
        try {
            Type t = this.getField(36, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-37: "Policy Deductible" - creates it if necessary
     */
    public CP getPolicyDeductible() { 
        CP ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-37: "Policy Deductible" - creates it if necessary
     */
    public CP getIn137_PolicyDeductible() { 
        CP ret = null;
        try {
            Type t = this.getField(37, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-38: "Policy Limit - Amount" - creates it if necessary
     */
    public CP getPolicyLimitAmount() { 
        CP ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-38: "Policy Limit - Amount" - creates it if necessary
     */
    public CP getIn138_PolicyLimitAmount() { 
        CP ret = null;
        try {
            Type t = this.getField(38, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-39: "Policy Limit - Days" - creates it if necessary
     */
    public NM getPolicyLimitDays() { 
        NM ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-39: "Policy Limit - Days" - creates it if necessary
     */
    public NM getIn139_PolicyLimitDays() { 
        NM ret = null;
        try {
            Type t = this.getField(39, 0);
            ret = (NM)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-40: "Room Rate - Semi-Private" - creates it if necessary
     */
    public CP getRoomRateSemiPrivate() { 
        CP ret = null;
        try {
            Type t = this.getField(40, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-40: "Room Rate - Semi-Private" - creates it if necessary
     */
    public CP getIn140_RoomRateSemiPrivate() { 
        CP ret = null;
        try {
            Type t = this.getField(40, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-41: "Room Rate - Private" - creates it if necessary
     */
    public CP getRoomRatePrivate() { 
        CP ret = null;
        try {
            Type t = this.getField(41, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-41: "Room Rate - Private" - creates it if necessary
     */
    public CP getIn141_RoomRatePrivate() { 
        CP ret = null;
        try {
            Type t = this.getField(41, 0);
            ret = (CP)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-42: "Insured's Employment Status" - creates it if necessary
     */
    public CE getInsuredSEmploymentStatus() { 
        CE ret = null;
        try {
            Type t = this.getField(42, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-42: "Insured's Employment Status" - creates it if necessary
     */
    public CE getIn142_InsuredSEmploymentStatus() { 
        CE ret = null;
        try {
            Type t = this.getField(42, 0);
            ret = (CE)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-43: "Insured's Administrative Sex" - creates it if necessary
     */
    public IS getInsuredSAdministrativeSex() { 
        IS ret = null;
        try {
            Type t = this.getField(43, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-43: "Insured's Administrative Sex" - creates it if necessary
     */
    public IS getIn143_InsuredSAdministrativeSex() { 
        IS ret = null;
        try {
            Type t = this.getField(43, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Insured's Employer's Address (IN1-44).
     */
    public XAD[] getInsuredSEmployerSAddress() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(44);  
            ret = new XAD[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (XAD)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insured's Employer's Address (IN1-44).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getInsuredSEmployerSAddressReps() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(44);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * IN1-44: "Insured's Employer's Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getInsuredSEmployerSAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(44, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN1-44: "Insured's Employer's Address" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public XAD getIn144_InsuredSEmployerSAddress(int rep) { 
        XAD ret = null;
        try {
            Type t = this.getField(44, rep);
            ret = (XAD)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insured's Employer's Address (IN1-44).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getIn144_InsuredSEmployerSAddressReps() {
        XAD[] ret = null;
        try {
            Type[] t = this.getField(44);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * IN1-44: "Insured's Employer's Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertInsuredSEmployerSAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(44, rep);
    }



    /**
     * Inserts a repetition of
     * IN1-44: "Insured's Employer's Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD insertIn144_InsuredSEmployerSAddress(int rep) throws HL7Exception { 
        return (XAD) super.insertRepetition(44, rep);
    }


    /**
     * Removes a repetition of
     * IN1-44: "Insured's Employer's Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removeInsuredSEmployerSAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(44, rep);
    }


    /**
     * Removes a repetition of
     * IN1-44: "Insured's Employer's Address" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public XAD removeIn144_InsuredSEmployerSAddress(int rep) throws HL7Exception { 
        return (XAD) super.removeRepetition(44, rep);
    }




    /**
     * Returns
     * IN1-45: "Verification Status" - creates it if necessary
     */
    public ST getVerificationStatus() { 
        ST ret = null;
        try {
            Type t = this.getField(45, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-45: "Verification Status" - creates it if necessary
     */
    public ST getIn145_VerificationStatus() { 
        ST ret = null;
        try {
            Type t = this.getField(45, 0);
            ret = (ST)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-46: "Prior Insurance Plan ID" - creates it if necessary
     */
    public IS getPriorInsurancePlanID() { 
        IS ret = null;
        try {
            Type t = this.getField(46, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-46: "Prior Insurance Plan ID" - creates it if necessary
     */
    public IS getIn146_PriorInsurancePlanID() { 
        IS ret = null;
        try {
            Type t = this.getField(46, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-47: "Coverage Type" - creates it if necessary
     */
    public IS getCoverageType() { 
        IS ret = null;
        try {
            Type t = this.getField(47, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-47: "Coverage Type" - creates it if necessary
     */
    public IS getIn147_CoverageType() { 
        IS ret = null;
        try {
            Type t = this.getField(47, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }



    /**
     * Returns
     * IN1-48: "Handicap" - creates it if necessary
     */
    public IS getHandicap() { 
        IS ret = null;
        try {
            Type t = this.getField(48, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns
     * IN1-48: "Handicap" - creates it if necessary
     */
    public IS getIn148_Handicap() { 
        IS ret = null;
        try {
            Type t = this.getField(48, 0);
            ret = (IS)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns all repetitions of Insured's ID Number (IN1-49).
     */
    public CX[] getInsuredSIDNumber() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(49);  
            ret = new CX[t.length];
            for (int i = 0; i < ret.length; i++) {
                ret[i] = (CX)t[i];
            }
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insured's ID Number (IN1-49).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getInsuredSIDNumberReps() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(49);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }


    /**
     * Returns a specific repetition of
     * IN1-49: "Insured's ID Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getInsuredSIDNumber(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(49, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }

    /**
     * Returns a specific repetition of
     * IN1-49: "Insured's ID Number" - creates it if necessary
     *
     * @param rep The repetition index (0-indexed)
     */
    public CX getIn149_InsuredSIDNumber(int rep) { 
        CX ret = null;
        try {
            Type t = this.getField(49, rep);
            ret = (CX)t;
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
        return ret;
    }


    /**
     * Returns a count of the current number of repetitions of Insured's ID Number (IN1-49).
     * This method does not create a repetition, so if no repetitions have currently been defined or accessed,
     * it will return zero.
     */
    public int getIn149_InsuredSIDNumberReps() {
        CX[] ret = null;
        try {
            Type[] t = this.getField(49);
            return t.length;  
        } catch (ClassCastException cce) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", cce);
            throw new RuntimeException(cce);
        } catch (HL7Exception he) {
            HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected problem obtaining field value.  This is a bug.", he);
            throw new RuntimeException(he);
        }
    }



    /**
     * Inserts a repetition of
     * IN1-49: "Insured's ID Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertInsuredSIDNumber(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(49, rep);
    }



    /**
     * Inserts a repetition of
     * IN1-49: "Insured's ID Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX insertIn149_InsuredSIDNumber(int rep) throws HL7Exception { 
        return (CX) super.insertRepetition(49, rep);
    }


    /**
     * Removes a repetition of
     * IN1-49: "Insured's ID Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removeInsuredSIDNumber(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(49, rep);
    }


    /**
     * Removes a repetition of
     * IN1-49: "Insured's ID Number" at a specific index
     *
     * @param rep The repetition index (0-indexed)
     * @throws HL7Exception If the rep is invalid (below 0, or too high for the allowable repetitions)
     */
    public CX removeIn149_InsuredSIDNumber(int rep) throws HL7Exception { 
        return (CX) super.removeRepetition(49, rep);
    }






    /** {@inheritDoc} */   
    protected Type createNewTypeWithoutReflection(int field) {
       switch (field) {
          case 0: return new SI(getMessage());
          case 1: return new CE(getMessage());
          case 2: return new CX(getMessage());
          case 3: return new XON(getMessage());
          case 4: return new XAD(getMessage());
          case 5: return new XPN(getMessage());
          case 6: return new XTN(getMessage());
          case 7: return new ST(getMessage());
          case 8: return new XON(getMessage());
          case 9: return new CX(getMessage());
          case 10: return new XON(getMessage());
          case 11: return new DT(getMessage());
          case 12: return new DT(getMessage());
          case 13: return new AUI(getMessage());
          case 14: return new IS(getMessage(), new Integer( 86 ));
          case 15: return new XPN(getMessage());
          case 16: return new CE(getMessage());
          case 17: return new TS(getMessage());
          case 18: return new XAD(getMessage());
          case 19: return new IS(getMessage(), new Integer( 135 ));
          case 20: return new IS(getMessage(), new Integer( 173 ));
          case 21: return new ST(getMessage());
          case 22: return new ID(getMessage(), new Integer( 136 ));
          case 23: return new DT(getMessage());
          case 24: return new ID(getMessage(), new Integer( 136 ));
          case 25: return new DT(getMessage());
          case 26: return new IS(getMessage(), new Integer( 93 ));
          case 27: return new ST(getMessage());
          case 28: return new TS(getMessage());
          case 29: return new XCN(getMessage());
          case 30: return new IS(getMessage(), new Integer( 98 ));
          case 31: return new IS(getMessage(), new Integer( 22 ));
          case 32: return new NM(getMessage());
          case 33: return new NM(getMessage());
          case 34: return new IS(getMessage(), new Integer( 42 ));
          case 35: return new ST(getMessage());
          case 36: return new CP(getMessage());
          case 37: return new CP(getMessage());
          case 38: return new NM(getMessage());
          case 39: return new CP(getMessage());
          case 40: return new CP(getMessage());
          case 41: return new CE(getMessage());
          case 42: return new IS(getMessage(), new Integer( 1 ));
          case 43: return new XAD(getMessage());
          case 44: return new ST(getMessage());
          case 45: return new IS(getMessage(), new Integer( 72 ));
          case 46: return new IS(getMessage(), new Integer( 309 ));
          case 47: return new IS(getMessage(), new Integer( 295 ));
          case 48: return new CX(getMessage());
          default: return null;
       }
   }


}

