/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.DFT_P11_FINANCIAL_COMMON_ORDER;
import ca.uhn.hl7v2.model.v24.group.DFT_P11_FINANCIAL_INSURANCE;
import ca.uhn.hl7v2.model.v24.group.DFT_P11_FINANCIAL_PROCEDURE;
import ca.uhn.hl7v2.model.v24.segment.DG1;
import ca.uhn.hl7v2.model.v24.segment.DRG;
import ca.uhn.hl7v2.model.v24.segment.FT1;
import ca.uhn.hl7v2.model.v24.segment.GT1;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.log.HapiLogFactory;

public class DFT_P11_FINANCIAL
extends AbstractGroup {
    public DFT_P11_FINANCIAL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(FT1.class, true, false);
            this.add(DFT_P11_FINANCIAL_PROCEDURE.class, false, true);
            this.add(DFT_P11_FINANCIAL_COMMON_ORDER.class, false, true);
            this.add(DG1.class, false, true);
            this.add(DRG.class, false, false);
            this.add(GT1.class, false, true);
            this.add(DFT_P11_FINANCIAL_INSURANCE.class, false, true);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error creating DFT_P11_FINANCIAL - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public FT1 getFT1() {
        FT1 ret = null;
        try {
            ret = (FT1)this.get("FT1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DFT_P11_FINANCIAL_PROCEDURE getFINANCIAL_PROCEDURE() {
        DFT_P11_FINANCIAL_PROCEDURE ret = null;
        try {
            ret = (DFT_P11_FINANCIAL_PROCEDURE)this.get("FINANCIAL_PROCEDURE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DFT_P11_FINANCIAL_PROCEDURE getFINANCIAL_PROCEDURE(int rep) {
        DFT_P11_FINANCIAL_PROCEDURE ret = null;
        try {
            ret = (DFT_P11_FINANCIAL_PROCEDURE)this.get("FINANCIAL_PROCEDURE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getFINANCIAL_PROCEDUREReps() {
        int reps = -1;
        try {
            reps = this.getAll("FINANCIAL_PROCEDURE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertFINANCIAL_PROCEDURE(DFT_P11_FINANCIAL_PROCEDURE structure, int rep) throws HL7Exception {
        super.insertRepetition("FINANCIAL_PROCEDURE", (Structure)structure, rep);
    }

    public DFT_P11_FINANCIAL_PROCEDURE insertFINANCIAL_PROCEDURE(int rep) throws HL7Exception {
        return (DFT_P11_FINANCIAL_PROCEDURE)super.insertRepetition("FINANCIAL_PROCEDURE", rep);
    }

    public DFT_P11_FINANCIAL_PROCEDURE removeFINANCIAL_PROCEDURE(int rep) throws HL7Exception {
        return (DFT_P11_FINANCIAL_PROCEDURE)super.removeRepetition("FINANCIAL_PROCEDURE", rep);
    }

    public DFT_P11_FINANCIAL_COMMON_ORDER getFINANCIAL_COMMON_ORDER() {
        DFT_P11_FINANCIAL_COMMON_ORDER ret = null;
        try {
            ret = (DFT_P11_FINANCIAL_COMMON_ORDER)this.get("FINANCIAL_COMMON_ORDER");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DFT_P11_FINANCIAL_COMMON_ORDER getFINANCIAL_COMMON_ORDER(int rep) {
        DFT_P11_FINANCIAL_COMMON_ORDER ret = null;
        try {
            ret = (DFT_P11_FINANCIAL_COMMON_ORDER)this.get("FINANCIAL_COMMON_ORDER", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getFINANCIAL_COMMON_ORDERReps() {
        int reps = -1;
        try {
            reps = this.getAll("FINANCIAL_COMMON_ORDER").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertFINANCIAL_COMMON_ORDER(DFT_P11_FINANCIAL_COMMON_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("FINANCIAL_COMMON_ORDER", (Structure)structure, rep);
    }

    public DFT_P11_FINANCIAL_COMMON_ORDER insertFINANCIAL_COMMON_ORDER(int rep) throws HL7Exception {
        return (DFT_P11_FINANCIAL_COMMON_ORDER)super.insertRepetition("FINANCIAL_COMMON_ORDER", rep);
    }

    public DFT_P11_FINANCIAL_COMMON_ORDER removeFINANCIAL_COMMON_ORDER(int rep) throws HL7Exception {
        return (DFT_P11_FINANCIAL_COMMON_ORDER)super.removeRepetition("FINANCIAL_COMMON_ORDER", rep);
    }

    public DG1 getDG1() {
        DG1 ret = null;
        try {
            ret = (DG1)this.get("DG1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DG1 getDG1(int rep) {
        DG1 ret = null;
        try {
            ret = (DG1)this.get("DG1", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getDG1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("DG1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", (Structure)structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public DRG getDRG() {
        DRG ret = null;
        try {
            ret = (DRG)this.get("DRG");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public GT1 getGT1() {
        GT1 ret = null;
        try {
            ret = (GT1)this.get("GT1");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public GT1 getGT1(int rep) {
        GT1 ret = null;
        try {
            ret = (GT1)this.get("GT1", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getGT1Reps() {
        int reps = -1;
        try {
            reps = this.getAll("GT1").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertGT1(GT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("GT1", (Structure)structure, rep);
    }

    public GT1 insertGT1(int rep) throws HL7Exception {
        return (GT1)super.insertRepetition("GT1", rep);
    }

    public GT1 removeGT1(int rep) throws HL7Exception {
        return (GT1)super.removeRepetition("GT1", rep);
    }

    public DFT_P11_FINANCIAL_INSURANCE getFINANCIAL_INSURANCE() {
        DFT_P11_FINANCIAL_INSURANCE ret = null;
        try {
            ret = (DFT_P11_FINANCIAL_INSURANCE)this.get("FINANCIAL_INSURANCE");
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public DFT_P11_FINANCIAL_INSURANCE getFINANCIAL_INSURANCE(int rep) {
        DFT_P11_FINANCIAL_INSURANCE ret = null;
        try {
            ret = (DFT_P11_FINANCIAL_INSURANCE)this.get("FINANCIAL_INSURANCE", rep);
        }
        catch (HL7Exception e) {
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)"Unexpected error accessing data - this is probably a bug in the source code generator.", (Throwable)e);
            throw new RuntimeException(e);
        }
        return ret;
    }

    public int getFINANCIAL_INSURANCEReps() {
        int reps = -1;
        try {
            reps = this.getAll("FINANCIAL_INSURANCE").length;
        }
        catch (HL7Exception e) {
            String message = "Unexpected error accessing data - this is probably a bug in the source code generator.";
            HapiLogFactory.getHapiLog(((Object)((Object)this)).getClass()).error((Object)message, (Throwable)e);
            throw new RuntimeException(message);
        }
        return reps;
    }

    public void insertFINANCIAL_INSURANCE(DFT_P11_FINANCIAL_INSURANCE structure, int rep) throws HL7Exception {
        super.insertRepetition("FINANCIAL_INSURANCE", (Structure)structure, rep);
    }

    public DFT_P11_FINANCIAL_INSURANCE insertFINANCIAL_INSURANCE(int rep) throws HL7Exception {
        return (DFT_P11_FINANCIAL_INSURANCE)super.insertRepetition("FINANCIAL_INSURANCE", rep);
    }

    public DFT_P11_FINANCIAL_INSURANCE removeFINANCIAL_INSURANCE(int rep) throws HL7Exception {
        return (DFT_P11_FINANCIAL_INSURANCE)super.removeRepetition("FINANCIAL_INSURANCE", rep);
    }
}

