/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.group.OUL_R21_CONTAINER;
import ca.uhn.hl7v2.model.v24.group.OUL_R21_OBSERVATION;
import ca.uhn.hl7v2.model.v24.segment.CTI;
import ca.uhn.hl7v2.model.v24.segment.NTE;
import ca.uhn.hl7v2.model.v24.segment.OBR;
import ca.uhn.hl7v2.model.v24.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OUL_R21_ORDER_OBSERVATION
extends AbstractGroup {
    public OUL_R21_ORDER_OBSERVATION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OUL_R21_CONTAINER.class, false, false);
            this.add(ORC.class, false, false);
            this.add(OBR.class, true, false);
            this.add(NTE.class, false, true);
            this.add(OUL_R21_OBSERVATION.class, true, true);
            this.add(CTI.class, false, true);
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating OUL_R21_ORDER_OBSERVATION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public OUL_R21_CONTAINER getCONTAINER() {
        OUL_R21_CONTAINER retVal = (OUL_R21_CONTAINER)this.getTyped("CONTAINER", OUL_R21_CONTAINER.class);
        return retVal;
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public OBR getOBR() {
        OBR retVal = (OBR)this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public OUL_R21_OBSERVATION getOBSERVATION() {
        OUL_R21_OBSERVATION retVal = (OUL_R21_OBSERVATION)this.getTyped("OBSERVATION", OUL_R21_OBSERVATION.class);
        return retVal;
    }

    public OUL_R21_OBSERVATION getOBSERVATION(int rep) {
        OUL_R21_OBSERVATION retVal = (OUL_R21_OBSERVATION)this.getTyped("OBSERVATION", rep, OUL_R21_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<OUL_R21_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", OUL_R21_OBSERVATION.class);
    }

    public void insertOBSERVATION(OUL_R21_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public OUL_R21_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (OUL_R21_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public OUL_R21_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (OUL_R21_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public CTI getCTI() {
        CTI retVal = (CTI)this.getTyped("CTI", CTI.class);
        return retVal;
    }

    public CTI getCTI(int rep) {
        CTI retVal = (CTI)this.getTyped("CTI", rep, CTI.class);
        return retVal;
    }

    public int getCTIReps() {
        return this.getReps("CTI");
    }

    public List<CTI> getCTIAll() throws HL7Exception {
        return this.getAllAsList("CTI", CTI.class);
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", (Structure)structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }
}

