/*
 * This class is an auto-generated source file for a HAPI
 * HL7 v2.x standard structure class.
 *
 * For more information, visit: http://hl7api.sourceforge.net/
 * 
 * The contents of this file are subject to the Mozilla Public License Version 1.1 
 * (the "License"); you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.mozilla.org/MPL/ 
 * Software distributed under the License is distributed on an "AS IS" basis, 
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License for the 
 * specific language governing rights and limitations under the License. 
 * 
 * The Original Code is "[file_name]".  Description: 
 * "[one_line_description]" 
 * 
 * The Initial Developer of the Original Code is University Health Network. Copyright (C) 
 * 2012.  All Rights Reserved. 
 * 
 * Contributor(s): ______________________________________. 
 * 
 * Alternatively, the contents of this file may be used under the terms of the 
 * GNU General Public License (the  "GPL"), in which case the provisions of the GPL are 
 * applicable instead of those above.  If you wish to allow use of your version of this 
 * file only under the terms of the GPL and not to allow others to use your version 
 * of this file under the MPL, indicate your decision by deleting  the provisions above 
 * and replace  them with the notice and other provisions required by the GPL License.  
 * If you do not delete the provisions above, a recipient may use your version of 
 * this file under either the MPL or the GPL. 
 * 
 */


package ca.uhn.hl7v2.model.v24.group;

import ca.uhn.hl7v2.model.v24.segment.*;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.model.*;

/**
 * <p>Represents a CSU_C09_PATIENT group structure (a Group object).
 * A Group is an ordered collection of message segments that can repeat together or be optionally in/excluded together.
 * This Group contains the following elements:  
 * </p>
 * <ul>
                         * <li>1: PID (Patient identification) <b>  </b></li>
                         * <li>2: PD1 (patient additional demographic) <b>optional  </b></li>
                         * <li>3: NTE (Notes and Comments) <b>optional repeating </b></li>
                         * <li>4: CSU_C09_VISIT (a Group object) <b>optional  </b></li>
                         * <li>5: CSR (Clinical Study Registration) <b>  </b></li>
                         * <li>6: CSU_C09_STUDY_PHASE (a Group object) <b> repeating </b></li>
 * </ul>
 */
//@SuppressWarnings("unused")
public class CSU_C09_PATIENT extends AbstractGroup {

    /** 
     * Creates a new CSU_C09_PATIENT group
     */
    public CSU_C09_PATIENT(Group parent, ModelClassFactory factory) {
       super(parent, factory);
       init(factory);
    }

    private void init(ModelClassFactory factory) {
       try {
                                  this.add(PID.class, true, false, false);
                                  this.add(PD1.class, false, false, false);
                                  this.add(NTE.class, false, true, false);
                                  this.add(CSU_C09_VISIT.class, false, false, false);
                                  this.add(CSR.class, true, false, false);
                                  this.add(CSU_C09_STUDY_PHASE.class, true, true, false);
       } catch(HL7Exception e) {
          log.error("Unexpected error creating CSU_C09_PATIENT - this is probably a bug in the source code generator.", e);
       }
    }

    /** 
     * Returns "2.4"
     */
    public String getVersion() {
       return "2.4";
    }



    /**
     * Returns
     * PID (Patient identification) - creates it if necessary
     */
    public PID getPID() { 
       PID retVal = getTyped("PID", PID.class);
       return retVal;
    }




    /**
     * Returns
     * PD1 (patient additional demographic) - creates it if necessary
     */
    public PD1 getPD1() { 
       PD1 retVal = getTyped("PD1", PD1.class);
       return retVal;
    }




    /**
     * Returns
     * the first repetition of 
     * NTE (Notes and Comments) - creates it if necessary
     */
    public NTE getNTE() { 
       NTE retVal = getTyped("NTE", NTE.class);
       return retVal;
    }


    /**
     * Returns a specific repetition of
     * NTE (Notes and Comments) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public NTE getNTE(int rep) { 
       NTE retVal = getTyped("NTE", rep, NTE.class);
       return retVal;
    }

    /** 
     * Returns the number of existing repetitions of NTE 
     */ 
    public int getNTEReps() {  
        return getReps("NTE");
    } 

    /** 
     * <p>
     * Returns a non-modifiable List containing all current existing repetitions of NTE.
     * <p>
     * <p>
     * Note that unlike {@link #getNTE()}, this method will not create any reps
     * if none are already present, so an empty list may be returned.
     * </p>
     */ 
    public java.util.List<NTE> getNTEAll() throws HL7Exception {
    	return getAllAsList("NTE", NTE.class);
    } 

    /**
     * Inserts a specific repetition of NTE (Notes and Comments)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertNTE(NTE structure, int rep) throws HL7Exception { 
       super.insertRepetition("NTE", structure, rep);
    }


    /**
     * Inserts a specific repetition of NTE (Notes and Comments)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public NTE insertNTE(int rep) throws HL7Exception { 
       return (NTE)super.insertRepetition("NTE", rep);
    }


    /**
     * Removes a specific repetition of NTE (Notes and Comments)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public NTE removeNTE(int rep) throws HL7Exception { 
       return (NTE)super.removeRepetition("NTE", rep);
    }



    /**
     * Returns
     * VISIT (a Group object) - creates it if necessary
     */
    public CSU_C09_VISIT getVISIT() { 
       CSU_C09_VISIT retVal = getTyped("VISIT", CSU_C09_VISIT.class);
       return retVal;
    }




    /**
     * Returns
     * CSR (Clinical Study Registration) - creates it if necessary
     */
    public CSR getCSR() { 
       CSR retVal = getTyped("CSR", CSR.class);
       return retVal;
    }




    /**
     * Returns
     * the first repetition of 
     * STUDY_PHASE (a Group object) - creates it if necessary
     */
    public CSU_C09_STUDY_PHASE getSTUDY_PHASE() { 
       CSU_C09_STUDY_PHASE retVal = getTyped("STUDY_PHASE", CSU_C09_STUDY_PHASE.class);
       return retVal;
    }


    /**
     * Returns a specific repetition of
     * STUDY_PHASE (a Group object) - creates it if necessary
     *
     * @param rep The repetition index (0-indexed, i.e. the first repetition is at index 0)
     * @throws HL7Exception if the repetition requested is more than one 
     *     greater than the number of existing repetitions.
     */
    public CSU_C09_STUDY_PHASE getSTUDY_PHASE(int rep) { 
       CSU_C09_STUDY_PHASE retVal = getTyped("STUDY_PHASE", rep, CSU_C09_STUDY_PHASE.class);
       return retVal;
    }

    /** 
     * Returns the number of existing repetitions of STUDY_PHASE 
     */ 
    public int getSTUDY_PHASEReps() {  
        return getReps("STUDY_PHASE");
    } 

    /** 
     * <p>
     * Returns a non-modifiable List containing all current existing repetitions of STUDY_PHASE.
     * <p>
     * <p>
     * Note that unlike {@link #getSTUDY_PHASE()}, this method will not create any reps
     * if none are already present, so an empty list may be returned.
     * </p>
     */ 
    public java.util.List<CSU_C09_STUDY_PHASE> getSTUDY_PHASEAll() throws HL7Exception {
    	return getAllAsList("STUDY_PHASE", CSU_C09_STUDY_PHASE.class);
    } 

    /**
     * Inserts a specific repetition of STUDY_PHASE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public void insertSTUDY_PHASE(CSU_C09_STUDY_PHASE structure, int rep) throws HL7Exception { 
       super.insertRepetition("STUDY_PHASE", structure, rep);
    }


    /**
     * Inserts a specific repetition of STUDY_PHASE (a Group object)
     * @see AbstractGroup#insertRepetition(Structure, int) 
     */
    public CSU_C09_STUDY_PHASE insertSTUDY_PHASE(int rep) throws HL7Exception { 
       return (CSU_C09_STUDY_PHASE)super.insertRepetition("STUDY_PHASE", rep);
    }


    /**
     * Removes a specific repetition of STUDY_PHASE (a Group object)
     * @see AbstractGroup#removeRepetition(String, int) 
     */
    public CSU_C09_STUDY_PHASE removeSTUDY_PHASE(int rep) throws HL7Exception { 
       return (CSU_C09_STUDY_PHASE)super.removeRepetition("STUDY_PHASE", rep);
    }



}

