/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.SI;
import ca.uhn.hl7v2.model.v24.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class CM2
extends AbstractSegment {
    public CM2(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID- CM2");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Scheduled Time Point");
            this.add(ST.class, false, 1, 300, new Object[]{this.getMessage()}, "Description of Time Point");
            this.add(CE.class, true, 200, 250, new Object[]{this.getMessage()}, "Events Scheduled This Time Point");
        }
        catch (HL7Exception e) {
            this.log.error("Unexpected error creating CM2 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDCM2() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getCm21_SetIDCM2() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getScheduledTimePoint() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getCm22_ScheduledTimePoint() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getDescriptionOfTimePoint() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getCm23_DescriptionOfTimePoint() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public CE[] getEventsScheduledThisTimePoint() {
        CE[] retVal = (CE[])this.getTypedField(4, (Type[])new CE[0]);
        return retVal;
    }

    public CE[] getCm24_EventsScheduledThisTimePoint() {
        CE[] retVal = (CE[])this.getTypedField(4, (Type[])new CE[0]);
        return retVal;
    }

    public int getEventsScheduledThisTimePointReps() {
        return this.getReps(4);
    }

    public CE getEventsScheduledThisTimePoint(int rep) {
        CE retVal = (CE)this.getTypedField(4, rep);
        return retVal;
    }

    public CE getCm24_EventsScheduledThisTimePoint(int rep) {
        CE retVal = (CE)this.getTypedField(4, rep);
        return retVal;
    }

    public int getCm24_EventsScheduledThisTimePointReps() {
        return this.getReps(4);
    }

    public CE insertEventsScheduledThisTimePoint(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(4, rep);
    }

    public CE insertCm24_EventsScheduledThisTimePoint(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(4, rep);
    }

    public CE removeEventsScheduledThisTimePoint(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(4, rep);
    }

    public CE removeCm24_EventsScheduledThisTimePoint(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(4, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

