/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class QPD
extends AbstractSegment {
    public QPD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Message Query Name");
            this.add(ST.class, false, 1, 32, new Object[]{this.getMessage()}, "Query Tag");
            this.add(Varies.class, false, 1, 256, new Object[]{this.getMessage()}, "User Parameters (in successive fields)");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating QPD - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getMessageQueryName() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getQpd1_MessageQueryName() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getQueryTag() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getQpd2_QueryTag() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public Varies getUserParametersInsuccessivefields() {
        Varies retVal = (Varies)this.getTypedField(3, 0);
        return retVal;
    }

    public Varies getQpd3_UserParametersInsuccessivefields() {
        Varies retVal = (Varies)this.getTypedField(3, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new Varies(this.getMessage());
            }
        }
        return null;
    }
}

