/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.ID;
import ca.uhn.hl7v2.model.v27.datatype.NM;
import ca.uhn.hl7v2.model.v27.datatype.NR;

public class DLT
extends AbstractComposite {
    private Type[] data;

    public DLT(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[4];
        this.data[0] = new NR(this.getMessage());
        this.data[1] = new NM(this.getMessage());
        this.data[2] = new ID(this.getMessage(), 523);
        this.data[3] = new NM(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public NR getNormalRange() {
        return (NR)this.getTyped(0, NR.class);
    }

    public NR getDlt1_NormalRange() {
        return (NR)this.getTyped(0, NR.class);
    }

    public NM getNumericThreshold() {
        return (NM)this.getTyped(1, NM.class);
    }

    public NM getDlt2_NumericThreshold() {
        return (NM)this.getTyped(1, NM.class);
    }

    public ID getChangeComputation() {
        return (ID)this.getTyped(2, ID.class);
    }

    public ID getDlt3_ChangeComputation() {
        return (ID)this.getTyped(2, ID.class);
    }

    public NM getDaysRetained() {
        return (NM)this.getTyped(3, NM.class);
    }

    public NM getDlt4_DaysRetained() {
        return (NM)this.getTyped(3, NM.class);
    }
}

