/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v27.group.OML_O39_OBSERVATION;
import ca.uhn.hl7v2.model.v27.group.OML_O39_SPECIMEN_SHIPMENT;
import ca.uhn.hl7v2.model.v27.segment.CTD;
import ca.uhn.hl7v2.model.v27.segment.DG1;
import ca.uhn.hl7v2.model.v27.segment.NTE;
import ca.uhn.hl7v2.model.v27.segment.OBR;
import ca.uhn.hl7v2.model.v27.segment.PRT;
import ca.uhn.hl7v2.model.v27.segment.TCD;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OML_O39_OBSERVATION_REQUEST
extends AbstractGroup {
    public OML_O39_OBSERVATION_REQUEST(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(OBR.class, true, false, false);
            this.add(TCD.class, false, false, false);
            this.add(NTE.class, false, true, false);
            this.add(PRT.class, false, true, false);
            this.add(CTD.class, false, false, false);
            this.add(DG1.class, false, true, false);
            this.add(OML_O39_OBSERVATION.class, false, true, false);
            this.add(OML_O39_SPECIMEN_SHIPMENT.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OML_O39_OBSERVATION_REQUEST - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public OBR getOBR() {
        OBR retVal = (OBR)this.getTyped("OBR", OBR.class);
        return retVal;
    }

    public TCD getTCD() {
        TCD retVal = (TCD)this.getTyped("TCD", TCD.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public PRT getPRT() {
        PRT retVal = (PRT)this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = (PRT)this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public CTD getCTD() {
        CTD retVal = (CTD)this.getTyped("CTD", CTD.class);
        return retVal;
    }

    public DG1 getDG1() {
        DG1 retVal = (DG1)this.getTyped("DG1", DG1.class);
        return retVal;
    }

    public DG1 getDG1(int rep) {
        DG1 retVal = (DG1)this.getTyped("DG1", rep, DG1.class);
        return retVal;
    }

    public int getDG1Reps() {
        return this.getReps("DG1");
    }

    public List<DG1> getDG1All() throws HL7Exception {
        return this.getAllAsList("DG1", DG1.class);
    }

    public void insertDG1(DG1 structure, int rep) throws HL7Exception {
        super.insertRepetition("DG1", (Structure)structure, rep);
    }

    public DG1 insertDG1(int rep) throws HL7Exception {
        return (DG1)super.insertRepetition("DG1", rep);
    }

    public DG1 removeDG1(int rep) throws HL7Exception {
        return (DG1)super.removeRepetition("DG1", rep);
    }

    public OML_O39_OBSERVATION getOBSERVATION() {
        OML_O39_OBSERVATION retVal = (OML_O39_OBSERVATION)this.getTyped("OBSERVATION", OML_O39_OBSERVATION.class);
        return retVal;
    }

    public OML_O39_OBSERVATION getOBSERVATION(int rep) {
        OML_O39_OBSERVATION retVal = (OML_O39_OBSERVATION)this.getTyped("OBSERVATION", rep, OML_O39_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<OML_O39_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", OML_O39_OBSERVATION.class);
    }

    public void insertOBSERVATION(OML_O39_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public OML_O39_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (OML_O39_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public OML_O39_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (OML_O39_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public OML_O39_SPECIMEN_SHIPMENT getSPECIMEN_SHIPMENT() {
        OML_O39_SPECIMEN_SHIPMENT retVal = (OML_O39_SPECIMEN_SHIPMENT)this.getTyped("SPECIMEN_SHIPMENT", OML_O39_SPECIMEN_SHIPMENT.class);
        return retVal;
    }

    public OML_O39_SPECIMEN_SHIPMENT getSPECIMEN_SHIPMENT(int rep) {
        OML_O39_SPECIMEN_SHIPMENT retVal = (OML_O39_SPECIMEN_SHIPMENT)this.getTyped("SPECIMEN_SHIPMENT", rep, OML_O39_SPECIMEN_SHIPMENT.class);
        return retVal;
    }

    public int getSPECIMEN_SHIPMENTReps() {
        return this.getReps("SPECIMEN_SHIPMENT");
    }

    public List<OML_O39_SPECIMEN_SHIPMENT> getSPECIMEN_SHIPMENTAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN_SHIPMENT", OML_O39_SPECIMEN_SHIPMENT.class);
    }

    public void insertSPECIMEN_SHIPMENT(OML_O39_SPECIMEN_SHIPMENT structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN_SHIPMENT", (Structure)structure, rep);
    }

    public OML_O39_SPECIMEN_SHIPMENT insertSPECIMEN_SHIPMENT(int rep) throws HL7Exception {
        return (OML_O39_SPECIMEN_SHIPMENT)super.insertRepetition("SPECIMEN_SHIPMENT", rep);
    }

    public OML_O39_SPECIMEN_SHIPMENT removeSPECIMEN_SHIPMENT(int rep) throws HL7Exception {
        return (OML_O39_SPECIMEN_SHIPMENT)super.removeRepetition("SPECIMEN_SHIPMENT", rep);
    }
}

