/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v27.group.ORL_O34_ORDER;
import ca.uhn.hl7v2.model.v27.group.ORL_O34_SPECIMEN_OBSERVATION;
import ca.uhn.hl7v2.model.v27.segment.SAC;
import ca.uhn.hl7v2.model.v27.segment.SPM;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class ORL_O34_SPECIMEN
extends AbstractGroup {
    public ORL_O34_SPECIMEN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SPM.class, true, false, false);
            this.add(ORL_O34_SPECIMEN_OBSERVATION.class, false, true, false);
            this.add(SAC.class, false, true, false);
            this.add(ORL_O34_ORDER.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ORL_O34_SPECIMEN - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public SPM getSPM() {
        SPM retVal = (SPM)this.getTyped("SPM", SPM.class);
        return retVal;
    }

    public ORL_O34_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION() {
        ORL_O34_SPECIMEN_OBSERVATION retVal = (ORL_O34_SPECIMEN_OBSERVATION)this.getTyped("SPECIMEN_OBSERVATION", ORL_O34_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public ORL_O34_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION(int rep) {
        ORL_O34_SPECIMEN_OBSERVATION retVal = (ORL_O34_SPECIMEN_OBSERVATION)this.getTyped("SPECIMEN_OBSERVATION", rep, ORL_O34_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public int getSPECIMEN_OBSERVATIONReps() {
        return this.getReps("SPECIMEN_OBSERVATION");
    }

    public List<ORL_O34_SPECIMEN_OBSERVATION> getSPECIMEN_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN_OBSERVATION", ORL_O34_SPECIMEN_OBSERVATION.class);
    }

    public void insertSPECIMEN_OBSERVATION(ORL_O34_SPECIMEN_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN_OBSERVATION", (Structure)structure, rep);
    }

    public ORL_O34_SPECIMEN_OBSERVATION insertSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (ORL_O34_SPECIMEN_OBSERVATION)super.insertRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public ORL_O34_SPECIMEN_OBSERVATION removeSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (ORL_O34_SPECIMEN_OBSERVATION)super.removeRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public SAC getSAC() {
        SAC retVal = (SAC)this.getTyped("SAC", SAC.class);
        return retVal;
    }

    public SAC getSAC(int rep) {
        SAC retVal = (SAC)this.getTyped("SAC", rep, SAC.class);
        return retVal;
    }

    public int getSACReps() {
        return this.getReps("SAC");
    }

    public List<SAC> getSACAll() throws HL7Exception {
        return this.getAllAsList("SAC", SAC.class);
    }

    public void insertSAC(SAC structure, int rep) throws HL7Exception {
        super.insertRepetition("SAC", (Structure)structure, rep);
    }

    public SAC insertSAC(int rep) throws HL7Exception {
        return (SAC)super.insertRepetition("SAC", rep);
    }

    public SAC removeSAC(int rep) throws HL7Exception {
        return (SAC)super.removeRepetition("SAC", rep);
    }

    public ORL_O34_ORDER getORDER() {
        ORL_O34_ORDER retVal = (ORL_O34_ORDER)this.getTyped("ORDER", ORL_O34_ORDER.class);
        return retVal;
    }

    public ORL_O34_ORDER getORDER(int rep) {
        ORL_O34_ORDER retVal = (ORL_O34_ORDER)this.getTyped("ORDER", rep, ORL_O34_ORDER.class);
        return retVal;
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<ORL_O34_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", ORL_O34_ORDER.class);
    }

    public void insertORDER(ORL_O34_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", (Structure)structure, rep);
    }

    public ORL_O34_ORDER insertORDER(int rep) throws HL7Exception {
        return (ORL_O34_ORDER)super.insertRepetition("ORDER", rep);
    }

    public ORL_O34_ORDER removeORDER(int rep) throws HL7Exception {
        return (ORL_O34_ORDER)super.removeRepetition("ORDER", rep);
    }
}

