/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v27.group.PPV_PCA_PATIENT;
import ca.uhn.hl7v2.model.v27.segment.ERR;
import ca.uhn.hl7v2.model.v27.segment.MSA;
import ca.uhn.hl7v2.model.v27.segment.MSH;
import ca.uhn.hl7v2.model.v27.segment.QAK;
import ca.uhn.hl7v2.model.v27.segment.QRD;
import ca.uhn.hl7v2.model.v27.segment.SFT;
import ca.uhn.hl7v2.model.v27.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class PPV_PCA
extends AbstractMessage {
    public PPV_PCA() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public PPV_PCA(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, true);
            this.add(QAK.class, false, false);
            this.add(QRD.class, true, false);
            this.add(PPV_PCA_PATIENT.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PPV_PCA - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return (SFT)this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return (SFT)this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", (Structure)structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return (UAC)this.getTyped("UAC", UAC.class);
    }

    public MSA getMSA() {
        return (MSA)this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return (ERR)this.getTyped("ERR", ERR.class);
    }

    public ERR getERR(int rep) {
        return (ERR)this.getTyped("ERR", rep, ERR.class);
    }

    public int getERRReps() {
        return this.getReps("ERR");
    }

    public List<ERR> getERRAll() throws HL7Exception {
        return this.getAllAsList("ERR", ERR.class);
    }

    public void insertERR(ERR structure, int rep) throws HL7Exception {
        super.insertRepetition("ERR", (Structure)structure, rep);
    }

    public ERR insertERR(int rep) throws HL7Exception {
        return (ERR)super.insertRepetition("ERR", rep);
    }

    public ERR removeERR(int rep) throws HL7Exception {
        return (ERR)super.removeRepetition("ERR", rep);
    }

    public QAK getQAK() {
        return (QAK)this.getTyped("QAK", QAK.class);
    }

    public QRD getQRD() {
        return (QRD)this.getTyped("QRD", QRD.class);
    }

    public PPV_PCA_PATIENT getPATIENT() {
        return (PPV_PCA_PATIENT)this.getTyped("PATIENT", PPV_PCA_PATIENT.class);
    }

    public PPV_PCA_PATIENT getPATIENT(int rep) {
        return (PPV_PCA_PATIENT)this.getTyped("PATIENT", rep, PPV_PCA_PATIENT.class);
    }

    public int getPATIENTReps() {
        return this.getReps("PATIENT");
    }

    public List<PPV_PCA_PATIENT> getPATIENTAll() throws HL7Exception {
        return this.getAllAsList("PATIENT", PPV_PCA_PATIENT.class);
    }

    public void insertPATIENT(PPV_PCA_PATIENT structure, int rep) throws HL7Exception {
        super.insertRepetition("PATIENT", (Structure)structure, rep);
    }

    public PPV_PCA_PATIENT insertPATIENT(int rep) throws HL7Exception {
        return (PPV_PCA_PATIENT)super.insertRepetition("PATIENT", rep);
    }

    public PPV_PCA_PATIENT removePATIENT(int rep) throws HL7Exception {
        return (PPV_PCA_PATIENT)super.removeRepetition("PATIENT", rep);
    }
}

