/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.NM;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ISD
extends AbstractSegment {
    public ISD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, true, 1, 0, new Object[]{this.getMessage()}, "Reference Interaction Number");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Interaction Type Identifier");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Interaction Active State");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ISD - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getReferenceInteractionNumber() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getIsd1_ReferenceInteractionNumber() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public CWE getInteractionTypeIdentifier() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getIsd2_InteractionTypeIdentifier() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getInteractionActiveState() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getIsd3_InteractionActiveState() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

