/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.CX;
import ca.uhn.hl7v2.model.v27.datatype.DT;
import ca.uhn.hl7v2.model.v27.datatype.ID;
import ca.uhn.hl7v2.model.v27.datatype.NULLDT;
import ca.uhn.hl7v2.model.v27.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PD1
extends AbstractSegment {
    public PD1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Living Dependency");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Living Arrangement");
            this.add(XON.class, false, 0, 0, new Object[]{this.getMessage()}, "Patient Primary Facility");
            this.add(NULLDT.class, false, 1, 0, new Object[]{this.getMessage()}, "Patient Primary Care Provider Name & ID No.");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Student Indicator");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Handicap");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Living Will Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Organ Donor Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Separate Bill");
            this.add(CX.class, false, 0, 0, new Object[]{this.getMessage()}, "Duplicate Patient");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Publicity Code");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Protection Indicator");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Protection Indicator Effective Date");
            this.add(XON.class, false, 0, 0, new Object[]{this.getMessage()}, "Place of Worship");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Advance Directive Code");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Immunization Registry Status");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Immunization Registry Status Effective Date");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Publicity Code Effective Date");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Military Branch");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Military Rank/Grade");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Military Status");
            this.add(DT.class, false, 1, 0, new Object[]{this.getMessage()}, "Advance Directive Last Verified Date");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PD1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CWE[] getLivingDependency() {
        CWE[] retVal = (CWE[])this.getTypedField(1, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getPd11_LivingDependency() {
        CWE[] retVal = (CWE[])this.getTypedField(1, (Type[])new CWE[0]);
        return retVal;
    }

    public int getLivingDependencyReps() {
        return this.getReps(1);
    }

    public CWE getLivingDependency(int rep) {
        CWE retVal = (CWE)this.getTypedField(1, rep);
        return retVal;
    }

    public CWE getPd11_LivingDependency(int rep) {
        CWE retVal = (CWE)this.getTypedField(1, rep);
        return retVal;
    }

    public int getPd11_LivingDependencyReps() {
        return this.getReps(1);
    }

    public CWE insertLivingDependency(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(1, rep);
    }

    public CWE insertPd11_LivingDependency(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(1, rep);
    }

    public CWE removeLivingDependency(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(1, rep);
    }

    public CWE removePd11_LivingDependency(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(1, rep);
    }

    public CWE getLivingArrangement() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getPd12_LivingArrangement() {
        CWE retVal = (CWE)this.getTypedField(2, 0);
        return retVal;
    }

    public XON[] getPatientPrimaryFacility() {
        XON[] retVal = (XON[])this.getTypedField(3, (Type[])new XON[0]);
        return retVal;
    }

    public XON[] getPd13_PatientPrimaryFacility() {
        XON[] retVal = (XON[])this.getTypedField(3, (Type[])new XON[0]);
        return retVal;
    }

    public int getPatientPrimaryFacilityReps() {
        return this.getReps(3);
    }

    public XON getPatientPrimaryFacility(int rep) {
        XON retVal = (XON)this.getTypedField(3, rep);
        return retVal;
    }

    public XON getPd13_PatientPrimaryFacility(int rep) {
        XON retVal = (XON)this.getTypedField(3, rep);
        return retVal;
    }

    public int getPd13_PatientPrimaryFacilityReps() {
        return this.getReps(3);
    }

    public XON insertPatientPrimaryFacility(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(3, rep);
    }

    public XON insertPd13_PatientPrimaryFacility(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(3, rep);
    }

    public XON removePatientPrimaryFacility(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(3, rep);
    }

    public XON removePd13_PatientPrimaryFacility(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(3, rep);
    }

    public NULLDT getPatientPrimaryCareProviderNameIDNo() {
        NULLDT retVal = (NULLDT)this.getTypedField(4, 0);
        return retVal;
    }

    public NULLDT getPd14_PatientPrimaryCareProviderNameIDNo() {
        NULLDT retVal = (NULLDT)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getStudentIndicator() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getPd15_StudentIndicator() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getHandicap() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getPd16_Handicap() {
        CWE retVal = (CWE)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getLivingWillCode() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getPd17_LivingWillCode() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getOrganDonorCode() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getPd18_OrganDonorCode() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public ID getSeparateBill() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public ID getPd19_SeparateBill() {
        ID retVal = (ID)this.getTypedField(9, 0);
        return retVal;
    }

    public CX[] getDuplicatePatient() {
        CX[] retVal = (CX[])this.getTypedField(10, (Type[])new CX[0]);
        return retVal;
    }

    public CX[] getPd110_DuplicatePatient() {
        CX[] retVal = (CX[])this.getTypedField(10, (Type[])new CX[0]);
        return retVal;
    }

    public int getDuplicatePatientReps() {
        return this.getReps(10);
    }

    public CX getDuplicatePatient(int rep) {
        CX retVal = (CX)this.getTypedField(10, rep);
        return retVal;
    }

    public CX getPd110_DuplicatePatient(int rep) {
        CX retVal = (CX)this.getTypedField(10, rep);
        return retVal;
    }

    public int getPd110_DuplicatePatientReps() {
        return this.getReps(10);
    }

    public CX insertDuplicatePatient(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(10, rep);
    }

    public CX insertPd110_DuplicatePatient(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(10, rep);
    }

    public CX removeDuplicatePatient(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(10, rep);
    }

    public CX removePd110_DuplicatePatient(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(10, rep);
    }

    public CWE getPublicityCode() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getPd111_PublicityCode() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getProtectionIndicator() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getPd112_ProtectionIndicator() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public DT getProtectionIndicatorEffectiveDate() {
        DT retVal = (DT)this.getTypedField(13, 0);
        return retVal;
    }

    public DT getPd113_ProtectionIndicatorEffectiveDate() {
        DT retVal = (DT)this.getTypedField(13, 0);
        return retVal;
    }

    public XON[] getPlaceOfWorship() {
        XON[] retVal = (XON[])this.getTypedField(14, (Type[])new XON[0]);
        return retVal;
    }

    public XON[] getPd114_PlaceOfWorship() {
        XON[] retVal = (XON[])this.getTypedField(14, (Type[])new XON[0]);
        return retVal;
    }

    public int getPlaceOfWorshipReps() {
        return this.getReps(14);
    }

    public XON getPlaceOfWorship(int rep) {
        XON retVal = (XON)this.getTypedField(14, rep);
        return retVal;
    }

    public XON getPd114_PlaceOfWorship(int rep) {
        XON retVal = (XON)this.getTypedField(14, rep);
        return retVal;
    }

    public int getPd114_PlaceOfWorshipReps() {
        return this.getReps(14);
    }

    public XON insertPlaceOfWorship(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(14, rep);
    }

    public XON insertPd114_PlaceOfWorship(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(14, rep);
    }

    public XON removePlaceOfWorship(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(14, rep);
    }

    public XON removePd114_PlaceOfWorship(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(14, rep);
    }

    public CWE[] getAdvanceDirectiveCode() {
        CWE[] retVal = (CWE[])this.getTypedField(15, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getPd115_AdvanceDirectiveCode() {
        CWE[] retVal = (CWE[])this.getTypedField(15, (Type[])new CWE[0]);
        return retVal;
    }

    public int getAdvanceDirectiveCodeReps() {
        return this.getReps(15);
    }

    public CWE getAdvanceDirectiveCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(15, rep);
        return retVal;
    }

    public CWE getPd115_AdvanceDirectiveCode(int rep) {
        CWE retVal = (CWE)this.getTypedField(15, rep);
        return retVal;
    }

    public int getPd115_AdvanceDirectiveCodeReps() {
        return this.getReps(15);
    }

    public CWE insertAdvanceDirectiveCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(15, rep);
    }

    public CWE insertPd115_AdvanceDirectiveCode(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(15, rep);
    }

    public CWE removeAdvanceDirectiveCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(15, rep);
    }

    public CWE removePd115_AdvanceDirectiveCode(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(15, rep);
    }

    public CWE getImmunizationRegistryStatus() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public CWE getPd116_ImmunizationRegistryStatus() {
        CWE retVal = (CWE)this.getTypedField(16, 0);
        return retVal;
    }

    public DT getImmunizationRegistryStatusEffectiveDate() {
        DT retVal = (DT)this.getTypedField(17, 0);
        return retVal;
    }

    public DT getPd117_ImmunizationRegistryStatusEffectiveDate() {
        DT retVal = (DT)this.getTypedField(17, 0);
        return retVal;
    }

    public DT getPublicityCodeEffectiveDate() {
        DT retVal = (DT)this.getTypedField(18, 0);
        return retVal;
    }

    public DT getPd118_PublicityCodeEffectiveDate() {
        DT retVal = (DT)this.getTypedField(18, 0);
        return retVal;
    }

    public CWE getMilitaryBranch() {
        CWE retVal = (CWE)this.getTypedField(19, 0);
        return retVal;
    }

    public CWE getPd119_MilitaryBranch() {
        CWE retVal = (CWE)this.getTypedField(19, 0);
        return retVal;
    }

    public CWE getMilitaryRankGrade() {
        CWE retVal = (CWE)this.getTypedField(20, 0);
        return retVal;
    }

    public CWE getPd120_MilitaryRankGrade() {
        CWE retVal = (CWE)this.getTypedField(20, 0);
        return retVal;
    }

    public CWE getMilitaryStatus() {
        CWE retVal = (CWE)this.getTypedField(21, 0);
        return retVal;
    }

    public CWE getPd121_MilitaryStatus() {
        CWE retVal = (CWE)this.getTypedField(21, 0);
        return retVal;
    }

    public DT getAdvanceDirectiveLastVerifiedDate() {
        DT retVal = (DT)this.getTypedField(22, 0);
        return retVal;
    }

    public DT getPd122_AdvanceDirectiveLastVerifiedDate() {
        DT retVal = (DT)this.getTypedField(22, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CWE(this.getMessage());
            }
            case 1: {
                return new CWE(this.getMessage());
            }
            case 2: {
                return new XON(this.getMessage());
            }
            case 3: {
                return new NULLDT(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new CWE(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new CWE(this.getMessage());
            }
            case 8: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 9: {
                return new CX(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 12: {
                return new DT(this.getMessage());
            }
            case 13: {
                return new XON(this.getMessage());
            }
            case 14: {
                return new CWE(this.getMessage());
            }
            case 15: {
                return new CWE(this.getMessage());
            }
            case 16: {
                return new DT(this.getMessage());
            }
            case 17: {
                return new DT(this.getMessage());
            }
            case 18: {
                return new CWE(this.getMessage());
            }
            case 19: {
                return new CWE(this.getMessage());
            }
            case 20: {
                return new CWE(this.getMessage());
            }
            case 21: {
                return new DT(this.getMessage());
            }
        }
        return null;
    }
}

