/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.CWE;
import ca.uhn.hl7v2.model.v27.datatype.DTM;
import ca.uhn.hl7v2.model.v27.datatype.EI;
import ca.uhn.hl7v2.model.v27.datatype.ID;
import ca.uhn.hl7v2.model.v27.datatype.PL;
import ca.uhn.hl7v2.model.v27.datatype.XAD;
import ca.uhn.hl7v2.model.v27.datatype.XCN;
import ca.uhn.hl7v2.model.v27.datatype.XON;
import ca.uhn.hl7v2.model.v27.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ROL
extends AbstractSegment {
    public ROL(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, false, 1, 0, new Object[]{this.getMessage()}, "Role Instance ID");
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(287)}, "Action Code");
            this.add(CWE.class, true, 1, 0, new Object[]{this.getMessage()}, "Role-ROL");
            this.add(XCN.class, true, 0, 0, new Object[]{this.getMessage()}, "Role Person");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Role Begin Date/Time");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Role End Date/Time");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Role Duration");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Role Action Reason");
            this.add(CWE.class, false, 0, 0, new Object[]{this.getMessage()}, "Provider Type");
            this.add(CWE.class, false, 1, 0, new Object[]{this.getMessage()}, "Organization Unit Type");
            this.add(XAD.class, false, 0, 0, new Object[]{this.getMessage()}, "Office/Home Address/Birthplace");
            this.add(XTN.class, false, 0, 0, new Object[]{this.getMessage()}, "Phone");
            this.add(PL.class, false, 1, 0, new Object[]{this.getMessage()}, "Person's Location");
            this.add(XON.class, false, 1, 0, new Object[]{this.getMessage()}, "Organization");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ROL - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public EI getRoleInstanceID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getRol1_RoleInstanceID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getRol2_ActionCode() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getRoleROL() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getRol3_RoleROL() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public XCN[] getRolePerson() {
        XCN[] retVal = (XCN[])this.getTypedField(4, (Type[])new XCN[0]);
        return retVal;
    }

    public XCN[] getRol4_RolePerson() {
        XCN[] retVal = (XCN[])this.getTypedField(4, (Type[])new XCN[0]);
        return retVal;
    }

    public int getRolePersonReps() {
        return this.getReps(4);
    }

    public XCN getRolePerson(int rep) {
        XCN retVal = (XCN)this.getTypedField(4, rep);
        return retVal;
    }

    public XCN getRol4_RolePerson(int rep) {
        XCN retVal = (XCN)this.getTypedField(4, rep);
        return retVal;
    }

    public int getRol4_RolePersonReps() {
        return this.getReps(4);
    }

    public XCN insertRolePerson(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(4, rep);
    }

    public XCN insertRol4_RolePerson(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(4, rep);
    }

    public XCN removeRolePerson(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(4, rep);
    }

    public XCN removeRol4_RolePerson(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(4, rep);
    }

    public DTM getRoleBeginDateTime() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public DTM getRol5_RoleBeginDateTime() {
        DTM retVal = (DTM)this.getTypedField(5, 0);
        return retVal;
    }

    public DTM getRoleEndDateTime() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getRol6_RoleEndDateTime() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public CWE getRoleDuration() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getRol7_RoleDuration() {
        CWE retVal = (CWE)this.getTypedField(7, 0);
        return retVal;
    }

    public CWE getRoleActionReason() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE getRol8_RoleActionReason() {
        CWE retVal = (CWE)this.getTypedField(8, 0);
        return retVal;
    }

    public CWE[] getProviderType() {
        CWE[] retVal = (CWE[])this.getTypedField(9, (Type[])new CWE[0]);
        return retVal;
    }

    public CWE[] getRol9_ProviderType() {
        CWE[] retVal = (CWE[])this.getTypedField(9, (Type[])new CWE[0]);
        return retVal;
    }

    public int getProviderTypeReps() {
        return this.getReps(9);
    }

    public CWE getProviderType(int rep) {
        CWE retVal = (CWE)this.getTypedField(9, rep);
        return retVal;
    }

    public CWE getRol9_ProviderType(int rep) {
        CWE retVal = (CWE)this.getTypedField(9, rep);
        return retVal;
    }

    public int getRol9_ProviderTypeReps() {
        return this.getReps(9);
    }

    public CWE insertProviderType(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(9, rep);
    }

    public CWE insertRol9_ProviderType(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(9, rep);
    }

    public CWE removeProviderType(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(9, rep);
    }

    public CWE removeRol9_ProviderType(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(9, rep);
    }

    public CWE getOrganizationUnitType() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getRol10_OrganizationUnitType() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public XAD[] getOfficeHomeAddressBirthplace() {
        XAD[] retVal = (XAD[])this.getTypedField(11, (Type[])new XAD[0]);
        return retVal;
    }

    public XAD[] getRol11_OfficeHomeAddressBirthplace() {
        XAD[] retVal = (XAD[])this.getTypedField(11, (Type[])new XAD[0]);
        return retVal;
    }

    public int getOfficeHomeAddressBirthplaceReps() {
        return this.getReps(11);
    }

    public XAD getOfficeHomeAddressBirthplace(int rep) {
        XAD retVal = (XAD)this.getTypedField(11, rep);
        return retVal;
    }

    public XAD getRol11_OfficeHomeAddressBirthplace(int rep) {
        XAD retVal = (XAD)this.getTypedField(11, rep);
        return retVal;
    }

    public int getRol11_OfficeHomeAddressBirthplaceReps() {
        return this.getReps(11);
    }

    public XAD insertOfficeHomeAddressBirthplace(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(11, rep);
    }

    public XAD insertRol11_OfficeHomeAddressBirthplace(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(11, rep);
    }

    public XAD removeOfficeHomeAddressBirthplace(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(11, rep);
    }

    public XAD removeRol11_OfficeHomeAddressBirthplace(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(11, rep);
    }

    public XTN[] getPhone() {
        XTN[] retVal = (XTN[])this.getTypedField(12, (Type[])new XTN[0]);
        return retVal;
    }

    public XTN[] getRol12_Phone() {
        XTN[] retVal = (XTN[])this.getTypedField(12, (Type[])new XTN[0]);
        return retVal;
    }

    public int getPhoneReps() {
        return this.getReps(12);
    }

    public XTN getPhone(int rep) {
        XTN retVal = (XTN)this.getTypedField(12, rep);
        return retVal;
    }

    public XTN getRol12_Phone(int rep) {
        XTN retVal = (XTN)this.getTypedField(12, rep);
        return retVal;
    }

    public int getRol12_PhoneReps() {
        return this.getReps(12);
    }

    public XTN insertPhone(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(12, rep);
    }

    public XTN insertRol12_Phone(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(12, rep);
    }

    public XTN removePhone(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(12, rep);
    }

    public XTN removeRol12_Phone(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(12, rep);
    }

    public PL getPersonSLocation() {
        PL retVal = (PL)this.getTypedField(13, 0);
        return retVal;
    }

    public PL getRol13_PersonSLocation() {
        PL retVal = (PL)this.getTypedField(13, 0);
        return retVal;
    }

    public XON getOrganization() {
        XON retVal = (XON)this.getTypedField(14, 0);
        return retVal;
    }

    public XON getRol14_Organization() {
        XON retVal = (XON)this.getTypedField(14, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(287));
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new XCN(this.getMessage());
            }
            case 4: {
                return new DTM(this.getMessage());
            }
            case 5: {
                return new DTM(this.getMessage());
            }
            case 6: {
                return new CWE(this.getMessage());
            }
            case 7: {
                return new CWE(this.getMessage());
            }
            case 8: {
                return new CWE(this.getMessage());
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new XAD(this.getMessage());
            }
            case 11: {
                return new XTN(this.getMessage());
            }
            case 12: {
                return new PL(this.getMessage());
            }
            case 13: {
                return new XON(this.getMessage());
            }
        }
        return null;
    }
}

