/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v27.datatype.DTM;
import ca.uhn.hl7v2.model.v27.datatype.ST;
import ca.uhn.hl7v2.model.v27.datatype.TX;
import ca.uhn.hl7v2.model.v27.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class SFT
extends AbstractSegment {
    public SFT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(XON.class, true, 1, 0, new Object[]{this.getMessage()}, "Software Vendor Organization");
            this.add(ST.class, true, 1, 0, new Object[]{this.getMessage()}, "Software Certified Version or Release Number");
            this.add(ST.class, true, 1, 0, new Object[]{this.getMessage()}, "Software Product Name");
            this.add(ST.class, true, 1, 0, new Object[]{this.getMessage()}, "Software Binary ID");
            this.add(TX.class, false, 1, 0, new Object[]{this.getMessage()}, "Software Product Information");
            this.add(DTM.class, false, 1, 0, new Object[]{this.getMessage()}, "Software Install Date");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating SFT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public XON getSoftwareVendorOrganization() {
        XON retVal = (XON)this.getTypedField(1, 0);
        return retVal;
    }

    public XON getSft1_SoftwareVendorOrganization() {
        XON retVal = (XON)this.getTypedField(1, 0);
        return retVal;
    }

    public ST getSoftwareCertifiedVersionOrReleaseNumber() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getSft2_SoftwareCertifiedVersionOrReleaseNumber() {
        ST retVal = (ST)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getSoftwareProductName() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getSft3_SoftwareProductName() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getSoftwareBinaryID() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getSft4_SoftwareBinaryID() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public TX getSoftwareProductInformation() {
        TX retVal = (TX)this.getTypedField(5, 0);
        return retVal;
    }

    public TX getSft5_SoftwareProductInformation() {
        TX retVal = (TX)this.getTypedField(5, 0);
        return retVal;
    }

    public DTM getSoftwareInstallDate() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    public DTM getSft6_SoftwareInstallDate() {
        DTM retVal = (DTM)this.getTypedField(6, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new XON(this.getMessage());
            }
            case 1: {
                return new ST(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new TX(this.getMessage());
            }
            case 5: {
                return new DTM(this.getMessage());
            }
        }
        return null;
    }
}

