/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v27.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v27.group.OSM_R26_CONTAINER;
import ca.uhn.hl7v2.model.v27.group.OSM_R26_SPECIMEN_OBSERVATION;
import ca.uhn.hl7v2.model.v27.group.OSM_R26_SUBJECT_PERSON_ANIMAL_IDENTIFICATION;
import ca.uhn.hl7v2.model.v27.group.OSM_R26_SUBJECT_POPULATION_LOCATION_IDENTIFICATION;
import ca.uhn.hl7v2.model.v27.segment.PRT;
import ca.uhn.hl7v2.model.v27.segment.SPM;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OSM_R26_SPECIMEN
extends AbstractGroup {
    public OSM_R26_SPECIMEN(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SPM.class, true, false, false);
            this.add(PRT.class, false, true, false);
            this.add(OSM_R26_SPECIMEN_OBSERVATION.class, false, true, false);
            this.add(OSM_R26_CONTAINER.class, false, true, false);
            this.add(OSM_R26_SUBJECT_PERSON_ANIMAL_IDENTIFICATION.class, false, false, false);
            this.add(OSM_R26_SUBJECT_POPULATION_LOCATION_IDENTIFICATION.class, false, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OSM_R26_SPECIMEN - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.7";
    }

    public SPM getSPM() {
        SPM retVal = (SPM)this.getTyped("SPM", SPM.class);
        return retVal;
    }

    public PRT getPRT() {
        PRT retVal = (PRT)this.getTyped("PRT", PRT.class);
        return retVal;
    }

    public PRT getPRT(int rep) {
        PRT retVal = (PRT)this.getTyped("PRT", rep, PRT.class);
        return retVal;
    }

    public int getPRTReps() {
        return this.getReps("PRT");
    }

    public List<PRT> getPRTAll() throws HL7Exception {
        return this.getAllAsList("PRT", PRT.class);
    }

    public void insertPRT(PRT structure, int rep) throws HL7Exception {
        super.insertRepetition("PRT", (Structure)structure, rep);
    }

    public PRT insertPRT(int rep) throws HL7Exception {
        return (PRT)super.insertRepetition("PRT", rep);
    }

    public PRT removePRT(int rep) throws HL7Exception {
        return (PRT)super.removeRepetition("PRT", rep);
    }

    public OSM_R26_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION() {
        OSM_R26_SPECIMEN_OBSERVATION retVal = (OSM_R26_SPECIMEN_OBSERVATION)this.getTyped("SPECIMEN_OBSERVATION", OSM_R26_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public OSM_R26_SPECIMEN_OBSERVATION getSPECIMEN_OBSERVATION(int rep) {
        OSM_R26_SPECIMEN_OBSERVATION retVal = (OSM_R26_SPECIMEN_OBSERVATION)this.getTyped("SPECIMEN_OBSERVATION", rep, OSM_R26_SPECIMEN_OBSERVATION.class);
        return retVal;
    }

    public int getSPECIMEN_OBSERVATIONReps() {
        return this.getReps("SPECIMEN_OBSERVATION");
    }

    public List<OSM_R26_SPECIMEN_OBSERVATION> getSPECIMEN_OBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("SPECIMEN_OBSERVATION", OSM_R26_SPECIMEN_OBSERVATION.class);
    }

    public void insertSPECIMEN_OBSERVATION(OSM_R26_SPECIMEN_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("SPECIMEN_OBSERVATION", (Structure)structure, rep);
    }

    public OSM_R26_SPECIMEN_OBSERVATION insertSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (OSM_R26_SPECIMEN_OBSERVATION)super.insertRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public OSM_R26_SPECIMEN_OBSERVATION removeSPECIMEN_OBSERVATION(int rep) throws HL7Exception {
        return (OSM_R26_SPECIMEN_OBSERVATION)super.removeRepetition("SPECIMEN_OBSERVATION", rep);
    }

    public OSM_R26_CONTAINER getCONTAINER() {
        OSM_R26_CONTAINER retVal = (OSM_R26_CONTAINER)this.getTyped("CONTAINER", OSM_R26_CONTAINER.class);
        return retVal;
    }

    public OSM_R26_CONTAINER getCONTAINER(int rep) {
        OSM_R26_CONTAINER retVal = (OSM_R26_CONTAINER)this.getTyped("CONTAINER", rep, OSM_R26_CONTAINER.class);
        return retVal;
    }

    public int getCONTAINERReps() {
        return this.getReps("CONTAINER");
    }

    public List<OSM_R26_CONTAINER> getCONTAINERAll() throws HL7Exception {
        return this.getAllAsList("CONTAINER", OSM_R26_CONTAINER.class);
    }

    public void insertCONTAINER(OSM_R26_CONTAINER structure, int rep) throws HL7Exception {
        super.insertRepetition("CONTAINER", (Structure)structure, rep);
    }

    public OSM_R26_CONTAINER insertCONTAINER(int rep) throws HL7Exception {
        return (OSM_R26_CONTAINER)super.insertRepetition("CONTAINER", rep);
    }

    public OSM_R26_CONTAINER removeCONTAINER(int rep) throws HL7Exception {
        return (OSM_R26_CONTAINER)super.removeRepetition("CONTAINER", rep);
    }

    public OSM_R26_SUBJECT_PERSON_ANIMAL_IDENTIFICATION getSUBJECT_PERSON_ANIMAL_IDENTIFICATION() {
        OSM_R26_SUBJECT_PERSON_ANIMAL_IDENTIFICATION retVal = (OSM_R26_SUBJECT_PERSON_ANIMAL_IDENTIFICATION)this.getTyped("SUBJECT_PERSON_ANIMAL_IDENTIFICATION", OSM_R26_SUBJECT_PERSON_ANIMAL_IDENTIFICATION.class);
        return retVal;
    }

    public OSM_R26_SUBJECT_POPULATION_LOCATION_IDENTIFICATION getSUBJECT_POPULATION_LOCATION_IDENTIFICATION() {
        OSM_R26_SUBJECT_POPULATION_LOCATION_IDENTIFICATION retVal = (OSM_R26_SUBJECT_POPULATION_LOCATION_IDENTIFICATION)this.getTyped("SUBJECT_POPULATION_LOCATION_IDENTIFICATION", OSM_R26_SUBJECT_POPULATION_LOCATION_IDENTIFICATION.class);
        return retVal;
    }
}

